/*  util.c  */

#include "../Utilities.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------------------------
   sort and count observations of two integers.

   input
      nobs -- # of observations
      x[]  -- vector of first components of observations
      y[]  -- vector of second components of observations

   output
      pndistinct -- pointer to hold # of distinct observations
      pxdistinct -- pointer to hold first components of the
                    distinct observations
      pydistinct -- pointer to hold second components of the
                    distinct observations
      pcounts    -- pointer to hold counts of the distinct observations

   created -- 95sep30, cca
   --------------------------------------------------------------------
*/
void
IV2sortAndCount (
   int   nobs,
   int   x[],
   int   y[],
   int   *pndistinct,
   int   **pxdistinct,
   int   **pydistinct,
   int   **pcounts
) {
int   count, i, ierr, j, ndistinct, xval, yval ;
int   *counts, *xdistinct, *ydistinct ;
/*
   ---------------
   check the input
   ---------------
*/
if (  nobs <= 0 || x == NULL || y == NULL
   || pndistinct == NULL
   || pxdistinct == NULL
   || pydistinct == NULL
   || pcounts == NULL ) {
   fprintf(stderr, 
           "\n fatal error in IV2sortAndCount(%d,%p,%p,%p,%p,%p,%p)"
           "\n bad input\n",
           nobs, x, y, pndistinct, pxdistinct, pydistinct, pcounts) ;
   exit(-1) ;
}
/*
   ----------------------------
   sort the observations by x[]
   ----------------------------
*/
#if MYDEBUG > 0
fprintf(stdout, "\n x before first sort") ;
IVfp80(stdout, nobs, x, 80, &ierr) ;
fprintf(stdout, "\n y before first sort") ;
IVfp80(stdout, nobs, y, 80, &ierr) ;
#endif
IV2qsortUp(nobs, x, y) ;
#if MYDEBUG > 0
fprintf(stdout, "\n x after first sort") ;
IVfp80(stdout, nobs, x, 80, &ierr) ;
fprintf(stdout, "\n y after first sort") ;
IVfp80(stdout, nobs, y, 80, &ierr) ;
#endif
/*
   ----------------------------
   sort the observations by x[]
   ----------------------------
*/
xval = x[0], count = 1, j = 0 ;
for ( i = 1 ; i < nobs ; i++ ) {
   if ( xval != x[i] ) {
      IVqsortUp(count, &y[j]) ;
      xval = x[i], count = 1, j = i ;
   } else {
      count++ ;
   }
}
IVqsortUp(count, &y[j]) ;
#if MYDEBUG > 0
fprintf(stdout, "\n x after second sort") ;
IVfp80(stdout, nobs, x, 80, &ierr) ;
fprintf(stdout, "\n y after second sort") ;
IVfp80(stdout, nobs, y, 80, &ierr) ;
#endif
/*
   -----------------------------------------
   count the number of distinct observations
   -----------------------------------------
*/
ndistinct = 1, xval = x[0], yval = y[0] ;
for ( i = 1 ; i < nobs ; i++ ) {
   if ( xval != x[i] || yval != y[i] ) {
      ndistinct++ ;
      xval = x[i] ;
      yval = y[i] ;
   }
}
/*
   ---------------------------------
   allocate storage and set pointers
   ---------------------------------
*/
*pndistinct = ndistinct ;
*pxdistinct = xdistinct = IVinit2(ndistinct) ;
*pydistinct = ydistinct = IVinit2(ndistinct) ;
*pcounts    = counts    = IVinit2(ndistinct) ;
/*
   ----------------
   fill the vectors
   ----------------
*/
j     = 0 ;
xval  = xdistinct[j] = x[0] ;
yval  = ydistinct[j] = y[0] ;
count = 1 ;
for ( i = 1 ; i < nobs ; i++ ) {
   if ( xval != x[i] || yval != y[i] ) {
      counts[j++] = count ;
      count = 1 ;
      xval  = xdistinct[j] = x[i] ;
      yval  = ydistinct[j] = y[i] ;
   } else {
      count++ ;
   }
}
counts[j++] = count ;

return ; }

/*--------------------------------------------------------------------*/
