/*  mdot.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]
      sums[2] = row0[*] * col2[*]
      sums[3] = row1[*] * col0[*]
      sums[4] = row1[*] * col1[*]
      sums[5] = row1[*] * col2[*]
      sums[6] = row2[*] * col0[*]
      sums[7] = row2[*] * col1[*]
      sums[8] = row2[*] * col2[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot3x3 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    row2[],
   double    col0[],
   double    col1[],
   double    col2[]
) {
double   s00, s01, s02, s10, s11, s12, s20, s21, s22 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL || row2 == NULL
   || col0 == NULL || col1 == NULL || col2 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot3x3(%p,%d,%p,%p,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, row2, col0, col1, col2) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 9 dot products
   --------------------------
*/
s00 = s01 = s02 = s10 = s11 = s12 = s20 = s21 = s22 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
   s02 += row0[i] * col2[i] ;
   s10 += row1[i] * col0[i] ;
   s11 += row1[i] * col1[i] ;
   s12 += row1[i] * col2[i] ;
   s20 += row2[i] * col0[i] ;
   s21 += row2[i] * col1[i] ;
   s22 += row2[i] * col2[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;
sums[2] = s02 ;
sums[3] = s10 ;
sums[4] = s11 ;
sums[5] = s12 ;
sums[6] = s20 ;
sums[7] = s21 ;
sums[8] = s22 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]
      sums[2] = row0[*] * col2[*]
      sums[3] = row1[*] * col0[*]
      sums[4] = row1[*] * col1[*]
      sums[5] = row1[*] * col2[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot2x3 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    col0[],
   double    col1[],
   double    col2[]
) {
double   s00, s01, s02, s10, s11, s12 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL 
   || col0 == NULL || col1 == NULL || col2 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot2x3(%p,%d,%p,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, col0, col1, col2) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 6 dot products
   --------------------------
*/
s00 = s01 = s02 = s10 = s11 = s12 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
   s02 += row0[i] * col2[i] ;
   s10 += row1[i] * col0[i] ;
   s11 += row1[i] * col1[i] ;
   s12 += row1[i] * col2[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;
sums[2] = s02 ;
sums[3] = s10 ;
sums[4] = s11 ;
sums[5] = s12 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]
      sums[2] = row0[*] * col2[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot1x3 (
   double    sums[],
   int       n,
   double    row0[],
   double    col0[],
   double    col1[],
   double    col2[]
) {
double   s00, s01, s02 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL 
   || col0 == NULL || col1 == NULL || col2 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot1x3(%p,%d,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, col0, col1, col2) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 3 dot products
   --------------------------
*/
s00 = s01 = s02 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
   s02 += row0[i] * col2[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;
sums[2] = s02 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]
      sums[2] = row1[*] * col0[*]
      sums[3] = row1[*] * col1[*]
      sums[4] = row2[*] * col0[*]
      sums[5] = row2[*] * col1[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot3x2 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    row2[],
   double    col0[],
   double    col1[]
) {
double   s00, s01, s10, s11, s20, s21 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL || row2 == NULL
   || col0 == NULL || col1 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot3x3(%p,%d,%p,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, row2, col0, col1) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 6 dot products
   --------------------------
*/
s00 = s01 = s10 = s11 = s20 = s21 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
   s10 += row1[i] * col0[i] ;
   s11 += row1[i] * col1[i] ;
   s20 += row2[i] * col0[i] ;
   s21 += row2[i] * col1[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;
sums[2] = s10 ;
sums[3] = s11 ;
sums[4] = s20 ;
sums[5] = s21 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]
      sums[3] = row1[*] * col0[*]
      sums[4] = row1[*] * col1[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot2x2 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    col0[],
   double    col1[]
) {
double   s00, s01, s10, s11 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL 
   || col0 == NULL || col1 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot2x2(%p,%d,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, col0, col1) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 4 dot products
   --------------------------
*/
s00 = s01 = s10 = s11 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
   s10 += row1[i] * col0[i] ;
   s11 += row1[i] * col1[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;
sums[2] = s10 ;
sums[3] = s11 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row0[*] * col1[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot1x2 (
   double    sums[],
   int       n,
   double    row0[],
   double    col0[],
   double    col1[]
) {
double   s00, s01 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL 
   || col0 == NULL || col1 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot1x2(%p,%d,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, col0, col1) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 2 dot products
   --------------------------
*/
s00 = s01 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s01 += row0[i] * col1[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s01 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row1[*] * col0[*]
      sums[2] = row2[*] * col0[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot3x1 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    row2[],
   double    col0[]
) {
double   s00, s10, s20 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL || row2 == NULL
   || col0 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot3x3(%p,%d,%p,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, row2, col0) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 3 dot products
   --------------------------
*/
s00 = s10 = s20 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s10 += row1[i] * col0[i] ;
   s20 += row2[i] * col0[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s10 ;
sums[2] = s20 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a multiple dot product

      sums[0] = row0[*] * col0[*]
      sums[1] = row1[*] * col0[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot2x1 (
   double    sums[],
   int       n,
   double    row0[],
   double    row1[],
   double    col0[]
) {
double   s00, s10 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL || row1 == NULL 
   || col0 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot2x1(%p,%d,%p,%p,%p)"
           "\n bad input\n",
           sums, n, row0, row1, col0) ;
   exit(-1) ;
}
/*
   --------------------------
   compute the 2 dot products
   --------------------------
*/
s00 = s10 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
   s10 += row1[i] * col0[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;
sums[1] = s10 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------
   purpose -- compute a dot product

      sums[0] = row0[*] * col0[*]

   created -- 96oct20, cca
   -----------------------------------------
*/
void
mdot1x1 (
   double    sums[],
   int       n,
   double    row0[],
   double    col0[]
) {
double   s00 ;
int      i ;
/*
   ---------------
   check the input
   ---------------
*/
if (  sums == NULL 
   || row0 == NULL 
   || col0 == NULL ) {
   fprintf(stderr, "\n fatal error in mdot1x1(%p,%d,%p,%p)"
           "\n bad input\n",
           sums, n, row0, col0) ;
   exit(-1) ;
}
/*
   ------------------------
   compute the dot products
   ------------------------
*/
s00 = 0.0 ;
for ( i = 0 ; i < n ; i++ ) {
   s00 += row0[i] * col0[i] ;
}
/*
   ----------------------
   store the dot products
   ----------------------
*/
sums[0] = s00 ;

return ; }

/*--------------------------------------------------------------------*/
