/*  IVsort.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   The insert and quick sort methods in this file are based on

   Jon L. Bentley and M. Douglas McIlroy,
   "Engineering a sort function",
   Software -- Practice and Experience, vol 23(11), 1249-1265,
   November 1993.

   This quick sort method uses 
      1) a median of three medians to find a split value, and
      2) split-end partitioning to handle many elements equal
         to the split value.
   -----------------------------------------------------------
*/
/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   sort an array of integers into ascending order using insert sort

   created -- 95sep28, cca
   ----------------------------------------------------------------
*/
void
IVisortUp (
   int   n,
   int   ivec[]
) {
int   i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec[j-1] > ivec[j] ; j-- ) {
      itemp     = ivec[j-1] ;
      ivec[j-1] = ivec[j]   ;
      ivec[j]   = itemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------------
   sort an array of integers into descending order using insert sort

   created -- 95sep29, cca
   -----------------------------------------------------------------
*/
void
IVisortDown (
   int   n,
   int   ivec[]
) {
int   i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec[j-1] < ivec[j] ; j-- ) {
      itemp     = ivec[j-1] ;
      ivec[j-1] = ivec[j]   ;
      ivec[j]   = itemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   static function, return the median of three integers
   ----------------------------------------------------
*/
static int
median3 ( 
   int   i,
   int   j,
   int   k,
   int   a[]
) {
if ( a[i] < a[j] ) {    
   /* a[i] < a[j] */
   if ( a[j] < a[k] ) { 
      /* a[i] < a[j] < a[k] */
      return(j) ;
   } else if ( a[i] < a[k] ) {
      /* a[i] < a[k] <= a[j] */
      return(k) ;
   } else {
      /* a[k] <= a[i] < a[j] */
      return(i) ;
   }
} else {
   /* a[j] <= a[i] */
   if ( a[i] < a[k] ) {
      /*  a[j] <= a[i] < a[k] */
      return(i) ;
   } else if ( a[j] < a[k] ) {
      /*  a[j] < a[k] <= a[i] */
      return(k) ;
   } else {
      /*  a[k] <= a[j] <= a[i] */
      return(j) ;
   }
}
}
/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   static function, 
   returns an approximation to the median value of a vector
   if n < 7 then
      returns a[n/2]
   else if n < 40 then
      returns median(a[0], a[n/2], a[n-1])
   else 
      returns median( median(a[0], a[s], a[2s])
                      median(a[n/2-s], a[n/2], a[n/2+s])
                      median(a[n-1-2s], a[n-1-s], a[n-1]) )
      where s = n / 8
   endif

   created -- 95sep28, cca
   ---------------------------------------------------------
*/
static int
centervalue (
   int   n,
   int   a[]
) {
int   i, j, k, s ;

j = n / 2 ;
if ( n > 7 ) {
   i = 0 ;
   k = n - 1 ;
   if ( n >= 40 ) {
      s = n / 8 ;
      i = median3(i, i+s, i+s+s, a) ;
      j = median3(j-s, j, j+s, a) ;
      k = median3(k-s-s, k-s, k, a) ;
   }
   j = median3(i, j, k, a) ;
}
return(a[j]) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   sort an array of integers into ascending order using quick sort

   created -- 95sep28, cca
   ---------------------------------------------------------------
*/
void
IVqsortUp (
   int   n,
   int   ivec[]
) {
int   a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IVisortUp(n, ivec) ;
} else {
   v = centervalue(n, ivec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec[b] <= v ) {
         if ( ivec[b] == v ) {
            itemp   = ivec[b] ;
            ivec[b] = ivec[a] ;
            ivec[a] = itemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec[c] >= v ) {
         if ( ivec[c] == v ) {
            itemp   = ivec[c] ;
            ivec[c] = ivec[d] ;
            ivec[d] = itemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp   = ivec[b] ;
      ivec[b] = ivec[c] ;
      ivec[c] = itemp ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp ;
      l++ ;
      h++ ;
   }
   IVqsortUp(b - a, ivec) ;
   IVqsortUp(d - c, ivec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   sort an array of integers into descending order using quick sort

   created -- 95sep29, cca
   ----------------------------------------------------------------
*/
void
IVqsortDown (
   int   n,
   int   ivec[]
) {
int   a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IVisortDown(n, ivec) ;
} else {
   v = centervalue(n, ivec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec[b] >= v ) {
         if ( ivec[b] == v ) {
            itemp   = ivec[b] ;
            ivec[b] = ivec[a] ;
            ivec[a] = itemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec[c] <= v ) {
         if ( ivec[c] == v ) {
            itemp   = ivec[c] ;
            ivec[c] = ivec[d] ;
            ivec[d] = itemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp   = ivec[b] ;
      ivec[b] = ivec[c] ;
      ivec[c] = itemp ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp ;
      l++ ;
      h++ ;
   }
   IVqsortDown(b - a, ivec) ;
   IVqsortDown(d - c, ivec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   return 1 if elements in array are in ascending order
   return 0 otherwise

   created -- 95sep28, cca
   ----------------------------------------------------
*/
int
IVisascending (
   int   n,
   int   ivec[]
) {
if ( n <= 0 ) {
   return(0) ;
} else if ( n == 1 ) {
   return(1) ;
} else {
   int   i ;
   for ( i = 1 ; i < n ; i++ ) {
      if ( ivec[i-1] > ivec[i] ) {
         return(0) ;
      }
   }
   return(1) ;
}
}
/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   return 1 if elements in array are in descending order
   return 0 otherwise

   created -- 95sep29, cca
   -----------------------------------------------------
*/
int
IVisdescending (
   int   n,
   int   ivec[]
) {
if ( n <= 0 ) {
   return(0) ;
} else if ( n == 1 ) {
   return(1) ;
} else {
   int   i ;
   for ( i = 1 ; i < n ; i++ ) {
      if ( ivec[i-1] < ivec[i] ) {
         return(0) ;
      }
   }
   return(1) ;
}
}
/*--------------------------------------------------------------------*/
