/*  IVDVsort.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   The insert and quick sort methods in this file are based on

   Jon L. Bentley and M. Douglas McIlroy,
   "Engineering a sort function",
   Software -- Practice and Experience, vol 23(11), 1249-1265,
   November 1993.

   This quick sort method uses 
      1) a median of three medians to find a split value, and
      2) split-end partitioning to handle many elements equal
         to the split value.
   -----------------------------------------------------------
*/
/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use insert sort to sort a pair of arrays.
   on output the first is in ascending order.
   ivec[] is the array of keys
   dvec[] is the companion array

   example,
      ivec[] =   5   8   3   2   9
      dvec[] = 1.0 2.0 3.0 4.0 5.0
   becomes
      ivec[] =   2   3   5   8   9
      dvec[] = 4.0 3.0 1.0 2.0 5.0

   created -- 95sep28, cca
   ------------------------------------------
*/
void
IVDVisortUp (
   int      n,
   int      ivec[],
   double   dvec[]
) {
double   dtemp ;
int      i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec[j-1] > ivec[j] ; j-- ) {
      itemp     = ivec[j-1] ;
      ivec[j-1] = ivec[j]   ;
      ivec[j]   = itemp     ;
      dtemp     = dvec[j-1] ;
      dvec[j-1] = dvec[j]   ;
      dvec[j]   = dtemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use insert sort to sort a pair or arrays.
   on output the first is in descending order.
   ivec[] is the array of keys
   dvec[] is the companion array

   example,
      ivec[] =   5   8   3   2   9
      dvec[] = 1.0 2.0 3.0 4.0 5.0
   becomes
      ivec[] =   9   8   5   3   2
      dvec[] = 5.0 2.0 1.0 3.0 4.0

   created -- 95sep29, cca
   -------------------------------------------
*/
void
IVDVisortDown (
   int      n,
   int      ivec[],
   double   dvec[]
) {
double   dtemp ;
int      i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec[j-1] < ivec[j] ; j-- ) {
      itemp     = ivec[j-1] ;
      ivec[j-1] = ivec[j]   ;
      ivec[j]   = itemp     ;
      dtemp     = dvec[j-1] ;
      dvec[j-1] = dvec[j]   ;
      dvec[j]   = dtemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   static function, return the median of three integers
   ----------------------------------------------------
*/
static int
median3 ( 
   int   i,
   int   j,
   int   k,
   int   a[]
) {
if ( a[i] < a[j] ) {    
   /* a[i] < a[j] */
   if ( a[j] < a[k] ) { 
      /* a[i] < a[j] < a[k] */
      return(j) ;
   } else if ( a[i] < a[k] ) {
      /* a[i] < a[k] <= a[j] */
      return(k) ;
   } else {
      /* a[k] <= a[i] < a[j] */
      return(i) ;
   }
} else {
   /* a[j] <= a[i] */
   if ( a[i] < a[k] ) {
      /*  a[j] <= a[i] < a[k] */
      return(i) ;
   } else if ( a[j] < a[k] ) {
      /*  a[j] < a[k] <= a[i] */
      return(k) ;
   } else {
      /*  a[k] <= a[j] <= a[i] */
      return(j) ;
   }
}
}
/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   static function, 
   returns an approximation to the median value of a vector
   if n < 7 then
      returns a[n/2]
   else if n < 40 then
      returns median(a[0], a[n/2], a[n-1])
   else 
      returns median( median(a[0], a[s], a[2s])
                      median(a[n/2-s], a[n/2], a[n/2+s])
                      median(a[n-1-2s], a[n-1-s], a[n-1]) )
      where s = n / 8
   endif

   created -- 95sep28, cca
   ---------------------------------------------------------
*/
static int
centervalue (
   int   n,
   int   a[]
) {
int   i, j, k, s ;

j = n / 2 ;
if ( n > 7 ) {
   i = 0 ;
   k = n - 1 ;
   if ( n >= 40 ) {
      s = n / 8 ;
      i = median3(i, i+s, i+s+s, a) ;
      j = median3(j-s, j, j+s, a) ;
      k = median3(k-s-s, k-s, k, a) ;
   }
   j = median3(i, j, k, a) ;
}
return(a[j]) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in ascending order.
   ivec[] is the array of keys
   dvec[] is the companion array

   example,
      ivec[] =   5   8   3   2   9
      dvec[] = 1.0 2.0 3.0 4.0 5.0
   becomes
      ivec[] =   2   3   5   8   9
      dvec[] = 4.0 3.0 1.0 2.0 5.0

   created -- 95sep29, cca
   ------------------------------------------
*/
void
IVDVqsortUp (
   int      n,
   int      ivec[],
   double   dvec[]
) {
double   dtemp ;
int      a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IVDVisortUp(n, ivec, dvec) ;
} else {
   v = centervalue(n, ivec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec[b] <= v ) {
         if ( ivec[b] == v ) {
            itemp   = ivec[b] ;
            ivec[b] = ivec[a] ;
            ivec[a] = itemp   ;
            dtemp   = dvec[b] ;
            dvec[b] = dvec[a] ;
            dvec[a] = dtemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec[c] >= v ) {
         if ( ivec[c] == v ) {
            itemp   = ivec[c] ;
            ivec[c] = ivec[d] ;
            ivec[d] = itemp   ;
            dtemp   = dvec[c] ;
            dvec[c] = dvec[d] ;
            dvec[d] = dtemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp   = ivec[b] ;
      ivec[b] = ivec[c] ;
      ivec[c] = itemp   ;
      dtemp   = dvec[b] ;
      dvec[b] = dvec[c] ;
      dvec[c] = dtemp   ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp   ;
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp   ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp   ;
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp   ;
      l++ ;
      h++ ;
   }
   IVDVqsortUp(b - a, ivec, dvec) ;
   IVDVqsortUp(d - c, ivec + n - (d - c), dvec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in descending order.
   ivec[] is the array of keys
   dvec[] is the companion array

   example,
      ivec[] =   5   8   3   2   9
      dvec[] = 1.0 2.0 3.0 4.0 5.0
   becomes
      ivec[] =   9   8   5   3   2
      dvec[] = 5.0 2.0 1.0 3.0 4.0

   created -- 95sep29, cca
   -------------------------------------------
*/
void
IVDVqsortDown (
   int      n,
   int      ivec[],
   double   dvec[]
) {
double   dtemp ;
int      a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IVDVisortDown(n, ivec, dvec) ;
} else {
   v = centervalue(n, ivec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec[b] >= v ) {
         if ( ivec[b] == v ) {
            itemp   = ivec[b] ;
            ivec[b] = ivec[a] ;
            ivec[a] = itemp   ;
            dtemp   = dvec[b] ;
            dvec[b] = dvec[a] ;
            dvec[a] = dtemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec[c] <= v ) {
         if ( ivec[c] == v ) {
            itemp   = ivec[c] ;
            ivec[c] = ivec[d] ;
            ivec[d] = itemp   ;
            dtemp   = dvec[c] ;
            dvec[c] = dvec[d] ;
            dvec[d] = dtemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp   = ivec[b] ;
      ivec[b] = ivec[c] ;
      ivec[c] = itemp   ;
      dtemp   = dvec[b] ;
      dvec[b] = dvec[c] ;
      dvec[c] = dtemp   ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp   ;
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp   ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp   = ivec[l] ;
      ivec[l] = ivec[h] ;
      ivec[h] = itemp   ;
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp   ;
      l++ ;
      h++ ;
   }
   IVDVqsortDown(b - a, ivec, dvec) ;
   IVDVqsortDown(d - c, ivec + n - (d - c), dvec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
