/*  IV2sort.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   The insert and quick sort methods in this file are based on

   Jon L. Bentley and M. Douglas McIlroy,
   "Engineering a sort function",
   Software -- Practice and Experience, vol 23(11), 1249-1265,
   November 1993.

   This quick sort method uses 
      1) a median of three medians to find a split value, and
      2) split-end partitioning to handle many elements equal
         to the split value.
   -----------------------------------------------------------
*/
/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use insert sort to sort a pair or arrays.
   on output the first is in ascending order.
   ivec1[] is the array of keys
   ivec2[] is the companion array

   example,
      ivec1[] = 5 8 3 2 9
      ivec2[] = 1 2 3 4 5
   becomes
      ivec1[] = 2 3 5 8 9
      ivec2[] = 4 3 1 2 5

   created -- 95sep28, cca
   ------------------------------------------
*/
void
IV2isortUp (
   int   n,
   int   ivec1[],
   int   ivec2[]
) {
int   i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec1[j-1] > ivec1[j] ; j-- ) {
      itemp      = ivec1[j-1] ;
      ivec1[j-1] = ivec1[j]   ;
      ivec1[j]   = itemp      ;
      itemp      = ivec2[j-1] ;
      ivec2[j-1] = ivec2[j]   ;
      ivec2[j]   = itemp      ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use insert sort to sort a pair or arrays.
   on output the first is in descending order.
   ivec1[] is the array of keys
   ivec2[] is the companion array

   example,
      ivec1[] = 5 8 3 2 9
      ivec2[] = 1 2 3 4 5
   becomes
      ivec1[] = 9 8 5 3 2
      ivec2[] = 5 2 1 3 4

   created -- 95sep29, cca
   -------------------------------------------
*/
void
IV2isortDown (
   int   n,
   int   ivec1[],
   int   ivec2[]
) {
int   i, itemp, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && ivec1[j-1] < ivec1[j] ; j-- ) {
      itemp      = ivec1[j-1] ;
      ivec1[j-1] = ivec1[j]   ;
      ivec1[j]   = itemp      ;
      itemp      = ivec2[j-1] ;
      ivec2[j-1] = ivec2[j]   ;
      ivec2[j]   = itemp      ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   static function, return the median of three integers
   ----------------------------------------------------
*/
static int
median3 ( 
   int   i,
   int   j,
   int   k,
   int   a[]
) {
if ( a[i] < a[j] ) {    
   /* a[i] < a[j] */
   if ( a[j] < a[k] ) { 
      /* a[i] < a[j] < a[k] */
      return(j) ;
   } else if ( a[i] < a[k] ) {
      /* a[i] < a[k] <= a[j] */
      return(k) ;
   } else {
      /* a[k] <= a[i] < a[j] */
      return(i) ;
   }
} else {
   /* a[j] <= a[i] */
   if ( a[i] < a[k] ) {
      /*  a[j] <= a[i] < a[k] */
      return(i) ;
   } else if ( a[j] < a[k] ) {
      /*  a[j] < a[k] <= a[i] */
      return(k) ;
   } else {
      /*  a[k] <= a[j] <= a[i] */
      return(j) ;
   }
}
}
/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   static function, 
   returns an approximation to the median value of a vector
   if n < 7 then
      returns a[n/2]
   else if n < 40 then
      returns median(a[0], a[n/2], a[n-1])
   else 
      returns median( median(a[0], a[s], a[2s])
                      median(a[n/2-s], a[n/2], a[n/2+s])
                      median(a[n-1-2s], a[n-1-s], a[n-1]) )
      where s = n / 8
   endif

   created -- 95sep28, cca
   ---------------------------------------------------------
*/
static int
centervalue (
   int   n,
   int   a[]
) {
int   i, j, k, s ;

j = n / 2 ;
if ( n > 7 ) {
   i = 0 ;
   k = n - 1 ;
   if ( n >= 40 ) {
      s = n / 8 ;
      i = median3(i, i+s, i+s+s, a) ;
      j = median3(j-s, j, j+s, a) ;
      k = median3(k-s-s, k-s, k, a) ;
   }
   j = median3(i, j, k, a) ;
}
return(a[j]) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in ascending order.
   ivec1[] is the array of keys
   ivec2[] is the companion array

   example,
      ivec1[] = 5 8 3 2 9
      ivec2[] = 1 2 3 4 5
   becomes
      ivec1[] = 2 3 5 8 9
      ivec2[] = 4 3 1 2 5

   created -- 95sep29, cca
   ------------------------------------------
*/
void
IV2qsortUp (
   int   n,
   int   ivec1[],
   int   ivec2[]
) {
int   a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IV2isortUp(n, ivec1, ivec2) ;
} else {
   v = centervalue(n, ivec1) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec1[b] <= v ) {
         if ( ivec1[b] == v ) {
            itemp    = ivec1[b] ;
            ivec1[b] = ivec1[a] ;
            ivec1[a] = itemp    ;
            itemp    = ivec2[b] ;
            ivec2[b] = ivec2[a] ;
            ivec2[a] = itemp    ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec1[c] >= v ) {
         if ( ivec1[c] == v ) {
            itemp    = ivec1[c] ;
            ivec1[c] = ivec1[d] ;
            ivec1[d] = itemp    ;
            itemp    = ivec2[c] ;
            ivec2[c] = ivec2[d] ;
            ivec2[d] = itemp    ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp    = ivec1[b] ;
      ivec1[b] = ivec1[c] ;
      ivec1[c] = itemp    ;
      itemp    = ivec2[b] ;
      ivec2[b] = ivec2[c] ;
      ivec2[c] = itemp    ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp    = ivec1[l] ;
      ivec1[l] = ivec1[h] ;
      ivec1[h] = itemp    ;
      itemp    = ivec2[l] ;
      ivec2[l] = ivec2[h] ;
      ivec2[h] = itemp    ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp    = ivec1[l] ;
      ivec1[l] = ivec1[h] ;
      ivec1[h] = itemp    ;
      itemp    = ivec2[l] ;
      ivec2[l] = ivec2[h] ;
      ivec2[h] = itemp    ;
      l++ ;
      h++ ;
   }
   IV2qsortUp(b - a, ivec1, ivec2) ;
   IV2qsortUp(d - c, ivec1 + n - (d - c), ivec2 + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in descending order.
   ivec1[] is the array of keys
   ivec2[] is the companion array

   example,
      ivec1[] = 5 8 3 2 9
      ivec2[] = 1 2 3 4 5
   becomes
      ivec1[] = 9 8 5 3 2
      ivec2[] = 5 2 1 3 4

   created -- 95sep29, cca
   -------------------------------------------
*/
void
IV2qsortDown (
   int   n,
   int   ivec1[],
   int   ivec2[]
) {
int   a, b, c, d, itemp, l, h, s, v ;

if ( n <= 10 ) {
   IV2isortDown(n, ivec1, ivec2) ;
} else {
   v = centervalue(n, ivec1) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && ivec1[b] >= v ) {
         if ( ivec1[b] == v ) {
            itemp    = ivec1[b] ;
            ivec1[b] = ivec1[a] ;
            ivec1[a] = itemp    ;
            itemp    = ivec2[b] ;
            ivec2[b] = ivec2[a] ;
            ivec2[a] = itemp    ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && ivec1[c] <= v ) {
         if ( ivec1[c] == v ) {
            itemp    = ivec1[c] ;
            ivec1[c] = ivec1[d] ;
            ivec1[d] = itemp    ;
            itemp    = ivec2[c] ;
            ivec2[c] = ivec2[d] ;
            ivec2[d] = itemp    ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      itemp    = ivec1[b] ;
      ivec1[b] = ivec1[c] ;
      ivec1[c] = itemp    ;
      itemp    = ivec2[b] ;
      ivec2[b] = ivec2[c] ;
      ivec2[c] = itemp    ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      itemp    = ivec1[l] ;
      ivec1[l] = ivec1[h] ;
      ivec1[h] = itemp    ;
      itemp    = ivec2[l] ;
      ivec2[l] = ivec2[h] ;
      ivec2[h] = itemp    ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      itemp    = ivec1[l] ;
      ivec1[l] = ivec1[h] ;
      ivec1[h] = itemp    ;
      itemp    = ivec2[l] ;
      ivec2[l] = ivec2[h] ;
      ivec2[h] = itemp    ;
      l++ ;
      h++ ;
   }
   IV2qsortDown(b - a, ivec1, ivec2) ;
   IV2qsortDown(d - c, ivec1 + n - (d - c), ivec2 + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
