/*  IP2.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/

void
IP2fprintf ( 
   FILE   *fp, 
   IP2    *ip 
)
/*
   ----------------------------------
   purpose -- to print out a IP2 list
   ----------------------------------
*/
{
int    i ;

if ( ip == NULL || fp == NULL ) {
   fprintf(stderr, "\n nonfatal error in IP2fprintf, file %s, line %d", 
           __FILE__, __LINE__) ;
   fprintf(stderr, ", invalid input\n") ;
   fprintf(stderr, "\n ip = %p, fp = %p", ip, fp) ;
   return ; 
}
i = 0 ;
while ( ip != NULL ) {
   if ( i % 8 == 0 ) fprintf(fp, "\n ") ;
   fprintf(fp, " <%d,%d>", ip->val1, ip->val2) ;
   ip = ip->next ;
   i++ ;
}
return ; }

/*--------------------------------------------------------------------*/

int
IP2fp80 ( 
   FILE   *fp, 
   IP2    *ip, 
   int    column 
)
/*
   ------------------------------------------------------------------
   purpose -- to write out an integer list with eighty column lines

   input --

      fp     -- file pointer, must be formatted and write access
      ip     -- head of list
      column -- present column
  
   return value -- present column
   ------------------------------------------------------------------
*/
{
int    inum, nchar, pow ;

if ( ip == NULL || fp == NULL ) {
   fprintf(stderr, "\n nonfatal error in IP2fp80, file %s, line %d", 
           __FILE__, __LINE__) ;
   fprintf(stderr, ", invalid input\n") ;
   return(column) ; 
}
while ( ip != NULL ) {
   nchar = 4 ;
   inum = ip->val1 ;
   if ( inum < 0 ) {
      inum = -inum ; 
      nchar += 3 ; 
   } else {
      nchar += 2 ; 
   }
   for ( pow = 10 ; inum >= pow ; pow *= 10 ) {
      nchar++ ; 
   }
   inum = ip->val2 ;
   if ( inum < 0 ) {
      inum = -inum ; 
      nchar += 3 ; 
   } else {
      nchar += 2 ; 
   }
   for ( pow = 10 ; inum >= pow ; pow *= 10 ) {
      nchar++ ; 
   }
   if ( (column += nchar) >= 80 ) {
      fprintf(fp, "\n") ;
      column = nchar ; 
   }
   fprintf(fp, " <%d,%d>", ip->val1, ip->val2) ; 
   ip = ip->next ;
}
return(column) ; }

/*--------------------------------------------------------------------*/

IP2 *
IP2init ( 
   int n, 
   int flag 
)
/*
*/
{
int    i ;
IP2    *base, *head, *ip, *tail ;

if ( n <= 0 ) {
   return(NULL) ;
}
ALLOCATE(base, struct _IP2, n) ;
switch ( flag ) {
case IP2_FORWARD :
   head = NULL ;
   for ( i = n - 1, ip = base + i ; i >= 0 ; i--, ip-- ) {
      ip->next = head ;
      ip->val1 = 0 ;
      ip->val2 = 0 ;
      head     = ip ;
   }
   break ;
case IP2_BACKWARD :
   head = tail = base + n - 1 ;
   head->val1 = 0 ;
   for ( i = n - 2, ip = head + i ; i >= 0 ; i--, ip-- ) {
      tail->next = ip ;
      ip->val1 = 0 ;
      ip->val2 = 0 ;
   }
   tail->next = NULL ;
   break ;
case IP2_NULL :
   for ( i = 0, ip = base ; i < n ; i++, ip++ ) {
      ip->val1 = 0 ;
      ip->val2 = 0 ;
      ip->next = NULL ;
   }
   break ;
}
return(base) ; }

/*--------------------------------------------------------------------*/

IP2 *
IP2mergeUp ( 
   IP2   *ip1, 
   IP2   *ip2 
)
/*
   ----------------------------------
   merge two lists in ascending order
   ----------------------------------
*/
{
IP2   *head, *tail ;
/*
   -------------------
   check for NULL list
   -------------------
*/
if ( ip1 == NULL ) {
   head = ip2 ;
} else if ( ip2 == NULL ) {
   head = ip1 ;
} else {
/*
   ------------------------------------------
   neither list is NULL, assign first element
   ------------------------------------------
*/
   if ( ip2->val1 < ip1->val1 ) {
      head = tail = ip2 ;
      ip2 = ip2->next ;
   } else {
      head = tail = ip1 ;
      ip1 = ip1->next ;
   }
/*
   --------------------------------------
   merge the lists until one is exhausted
   --------------------------------------
*/
   while ( ip1 != NULL && ip2 != NULL ) {
      if ( ip2->val1 < ip1->val1 ) {
         tail->next = ip2 ;
         tail = ip2 ;
         ip2 = ip2->next ;
      } else {
         tail->next = ip1 ;
         tail = ip1 ;
         ip1 = ip1->next ;
      }
   }
/*
   ----------------------------------
   add the remaining list to the tail
   ----------------------------------
*/
/*
   if ( ip1 == NULL ) {
      tail->next = ip2 ;
      tail = ip2 ;
   } else {
      tail->next = ip1 ;
      tail = ip1 ;
   }
*/
   if ( ip1 == NULL ) {
      tail->next = ip2 ;
   } else {
      tail->next = ip1 ;
   }
}

return(head) ; }

/*--------------------------------------------------------------------*/

IP2 *
IP2mergeSortUp ( 
   IP2   *ip0 )
/*
*/
{
int   i, m, m1 ;
IP2   *ip, *ip1, *ip2, *prev ;
/*
   ----------------------------------------
   count the number of elements in the list
   ----------------------------------------
*/
/*
fprintf(stdout, "\n inside IP2mergeSortUp :") ;
IP2fp80(stdout, ip0, 25) ;
fflush(stdout) ;
*/
for ( ip = ip0, m = 0 ; ip != NULL ; ip = ip->next ) {
   m++ ;
}
if ( m <= 1 ) {
   return(ip0) ;
} else {
   m1 = m / 2 ;
/*
fprintf(stdout, "\n m = %d, m1 = %d, m2 = %d", m, m1, m-m1) ;
fflush(stdout) ;
*/
   for ( i = 1, ip = ip0, prev = NULL ; i < m1 ; i++ ) {
      prev = ip ;
      ip = ip->next ;
   }
   ip2 = ip->next ;
   ip->next = NULL ;
   ip1 = ip0 ;
/*
fprintf(stdout, "\n calling IP2mergeSortUp :") ;
IP2fp80(stdout, ip1, 13) ;
fflush(stdout) ;
*/
   ip1 = IP2mergeSortUp(ip1) ;
/*
fprintf(stdout, "\n return from IP2mergeSortUp :") ;
IP2fp80(stdout, ip1, 13) ;
fprintf(stdout, "\n calling IP2mergeSortUp :") ;
IP2fp80(stdout, ip2, 13) ;
*/
   ip2 = IP2mergeSortUp(ip2) ;
/*
fprintf(stdout, "\n return from IP2mergeSortUp :") ;
IP2fp80(stdout, ip2, 13) ;
fprintf(stdout, "\n calling IP2mergeUp :") ;
fprintf(stdout, "\n first list") ;
IP2fp80(stdout, ip1, 13) ;
fprintf(stdout, "\n second list") ;
IP2fp80(stdout, ip2, 13) ;
*/
   ip  = IP2mergeUp(ip1, ip2) ;
/*
fprintf(stdout, "\n return from IP2mergeUp, sorted list : ") ;
IP2fp80(stdout, ip, 40) ;
fflush(stdout) ;
*/
   return(ip) ; 
}
}
/*--------------------------------------------------------------------*/
