/*  I2P.c  */

#include "../Utilities.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   initializer. 
   create and return an array of n I2P structures.
   the structures are linked in one of three ways.
   flag = 0 (I2P_NULL)     --> ip->next = NULL
   flag = 1 (I2P_FORWARD)  --> ip->next = successor in list
   flag = 2 (I2P_BACKWARD) --> ip->next = predecessor in list
   
   created -- 96nov02, cca
   ---------------------------------------------------------
*/
I2P *
I2P_init ( 
   int   n, 
   int   flag 
) {
I2P    *base ;
/*
   ---------------
   check the input
   ---------------
*/
if ( n <= 0 || flag < I2P_NULL || flag > I2P_BACKWARD ) {
   fprintf(stderr, "\n fatal error in I2P_init(%d,%d)"
           "\n bad input\n", n, flag) ;
   exit(-1) ;
}
/*
   --------------------
   allocate the storage
   --------------------
*/
ALLOCATE(base, struct _I2P, n) ;
/*
   -----------------------
   initialize the elements
   -----------------------
*/
I2P_initStorage(n, flag, base) ;

return(base) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   initializer. 
   create and return an array of n I2P structures.
   the structures are linked in one of three ways.
   flag = 0 (I2P_NULL)     --> ip->next = NULL
   flag = 1 (I2P_FORWARD)  --> ip->next = successor in list
   flag = 2 (I2P_BACKWARD) --> ip->next = predecessor in list
   
   created -- 96nov02, cca
   ---------------------------------------------------------
*/
void
I2P_initStorage ( 
   int   n, 
   int   flag,
   I2P   *base
) {
I2P   *elem, *firstelem, *lastelem ;
/*
   ---------------
   check the input
   ---------------
*/
if (  n <= 0 || flag < I2P_NULL || flag > I2P_BACKWARD 
   || base == NULL ) {
   fprintf(stderr, "\n fatal error in I2P_initStorage(%d,%d,%p)"
   "\n bad input\n", n, flag, base) ;
   exit(-1) ;
}
#if MYDEBUG > 0
fprintf(stdout, "\n inside I2P_initStorage(%d, %d, %p)",
        n, flag, base) ;
#endif
/*
   -----------------------
   initialize the elements
   -----------------------
*/
firstelem = base ;
lastelem  = firstelem + n - 1 ;
#if MYDEBUG > 0
fprintf(stdout, "\n firstelem %p, lastelem %p",
        firstelem, lastelem) ;
#endif
switch ( flag ) {
case I2P_FORWARD :
   for ( elem = firstelem ; elem < lastelem ; elem++ ) {
      elem->value0 = elem->value1 = -1 ;
      elem->next   = elem + 1 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n elem %p, value0 %d, value1 %d, next %p",
              elem, elem->value0, elem->value1, elem->next) ;
#endif
   }
   lastelem->value0 = lastelem->value1 = - 1 ;
   lastelem->next = NULL ;
#if MYDEBUG > 0
   fprintf(stdout, "\n elem %p, value0 %d, value1 %d, next %p",
        lastelem, lastelem->value0, lastelem->value1, lastelem->next) ;
#endif
   break ;
case I2P_BACKWARD :
   for ( elem = firstelem + 1 ; elem <= lastelem ; elem++ ) {
      elem->value0 = elem->value1 = -1 ;
      elem->next = elem - 1 ;
   }
   firstelem->value0 = firstelem->value1 = - 1 ;
   firstelem->next = NULL ;
   break ;
case I2P_NULL :
   for ( elem = firstelem ; elem <= lastelem ; elem++ ) {
      elem->value0 = elem->value1 = -1 ;
      elem->next = NULL ;
   }
   break ;
default :
   break ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------
   free the storage for an array of I2P structures,
   must have been allocated by I2P_init

   created -- 96nov02, cca
   -----------------------------------------------
*/
void
I2P_free ( 
   I2P   *ip
) {
if ( ip != NULL ) {
   FREE(ip) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   purpose -- to print out a I2P list
   
   created -- 96nov02, cca
   ----------------------------------
*/
void
I2P_fprintf ( 
   FILE   *fp, 
   I2P    *elem 
) {
if ( fp != NULL && elem != NULL ) {
   int   i = 0 ;
   while ( elem != NULL ) {
      if ( i % 8 == 0 ) fprintf(fp, "\n ") ;
      fprintf(fp, " <%4d,%4d>", elem->value0, elem->value1) ;
      elem = elem->next ;
      i++ ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------------------------
   purpose -- to write out an integer list with eighty column lines

   input --

      fp     -- file pointer, must be formatted and write access
      elem   -- head of list
      column -- present column
  
   return value -- present column
   
   created -- 96nov02, cca
   ------------------------------------------------------------------
*/
int
I2P_fp80 ( 
   FILE   *fp, 
   I2P    *elem, 
   int    column 
) {
if ( fp != NULL && elem != NULL ) {
   int    inum, nchar ;
   while ( elem != NULL ) {
      inum = elem->value0 ;
      if ( inum < 0 ) {
         inum = -inum ; 
         nchar = 2 ; 
      } else if ( inum == 0 ) {
         nchar = 2 ; 
      } else {
         nchar = 1 ; 
      }
      while ( inum > 0 ) {
         nchar++ ;
         inum /= 10 ;
      }
      nchar++ ;
      inum = elem->value1 ;
      if ( inum < 0 ) {
         inum = -inum ; 
         nchar = 2 ; 
      } else if ( inum == 0 ) {
         nchar = 2 ; 
      } else {
         nchar = 1 ; 
      }
      while ( inum > 0 ) {
         nchar++ ;
         inum /= 10 ;
      }
      if ( (column += nchar) >= 80 ) {
         fprintf(fp, "\n") ;
         column = nchar ; 
      }
      fprintf(fp, " <%d,%d>", elem->value0, elem->value1) ; 
      elem = elem->next ;
   }
}
return(column) ; }

/*--------------------------------------------------------------------*/
