/*  DVsort.c  */

#include "../Utilities.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   The insert and quick sort methods in this file are based on

   Jon L. Bentley and M. Douglas McIlroy,
   "Engineering a sort function",
   Software -- Practice and Experience, vol 23(11), 1249-1265,
   November 1993.

   This quick sort method uses 
      1) a median of three medians to find a split value, and
      2) split-end partitioning to handle many elements equal
         to the split value.
   -----------------------------------------------------------
*/
/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   sort an array of doubles into ascending order using insert sort

   created -- 95nov25, cca
   ----------------------------------------------------------------
*/
void
DVisortUp (
   int      n,
   double   dvec[]
) {
double   dtemp ;
int      i, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && dvec[j-1] > dvec[j] ; j-- ) {
      dtemp     = dvec[j-1] ;
      dvec[j-1] = dvec[j]   ;
      dvec[j]   = dtemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------------
   sort an array of doubles into descending order using insert sort

   created -- 95sep29, cca
   -----------------------------------------------------------------
*/
void
DVisortDown (
   int      n,
   double   dvec[]
) {
double   dtemp ;
int      i, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && dvec[j-1] < dvec[j] ; j-- ) {
      dtemp     = dvec[j-1] ;
      dvec[j-1] = dvec[j]   ;
      dvec[j]   = dtemp     ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use insert sort to sort a pair or arrays.
   on output the first is in ascending order.
   dvec1[] is the array of keys
   dvec2[] is the companion array

   example,
      dvec1[] = 5 8 3 2 9
      dvec2[] = 1 2 3 4 5
   becomes
      dvec1[] = 2 3 5 8 9
      dvec2[] = 4 3 1 2 5

   created -- 95nov25, cca
   ------------------------------------------
*/
void
DV2isortUp (
   int      n,
   double   dvec1[],
   double   dvec2[]
) {
double   dtemp ;
int      i, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && dvec1[j-1] > dvec1[j] ; j-- ) {
      dtemp      = dvec1[j-1] ;
      dvec1[j-1] = dvec1[j]   ;
      dvec1[j]   = dtemp      ;
      dtemp      = dvec2[j-1] ;
      dvec2[j-1] = dvec2[j]   ;
      dvec2[j]   = dtemp      ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use insert sort to sort a pair or arrays.
   on output the first is in descending order.
   dvec1[] is the array of keys
   dvec2[] is the companion array

   example,
      dvec1[] = 5 8 3 2 9
      dvec2[] = 1 2 3 4 5
   becomes
      dvec1[] = 9 8 5 3 2
      dvec2[] = 5 2 1 3 4

   created -- 95sep29, cca
   -------------------------------------------
*/
void
DV2isortDown (
   int      n,
   double   dvec1[],
   double   dvec2[]
) {
double   dtemp ;
int      i, j ;

for ( i = 1 ; i < n ; i++ ) {
   for ( j = i ; j > 0 && dvec1[j-1] < dvec1[j] ; j-- ) {
      dtemp      = dvec1[j-1] ;
      dvec1[j-1] = dvec1[j]   ;
      dvec1[j]   = dtemp      ;
      dtemp      = dvec2[j-1] ;
      dvec2[j-1] = dvec2[j]   ;
      dvec2[j]   = dtemp      ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   static function, return the median of three doubles
   ----------------------------------------------------
*/
static int
median3 ( 
   int      i,
   int      j,
   int      k,
   double   a[]
) {
if ( a[i] < a[j] ) {    
   /* a[i] < a[j] */
   if ( a[j] < a[k] ) { 
      /* a[i] < a[j] < a[k] */
      return(j) ;
   } else if ( a[i] < a[k] ) {
      /* a[i] < a[k] <= a[j] */
      return(k) ;
   } else {
      /* a[k] <= a[i] < a[j] */
      return(i) ;
   }
} else {
   /* a[j] <= a[i] */
   if ( a[i] < a[k] ) {
      /*  a[j] <= a[i] < a[k] */
      return(i) ;
   } else if ( a[j] < a[k] ) {
      /*  a[j] < a[k] <= a[i] */
      return(k) ;
   } else {
      /*  a[k] <= a[j] <= a[i] */
      return(j) ;
   }
}
}
/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   static function, 
   returns an approximation to the median value of a vector
   if n < 7 then
      returns a[n/2]
   else if n < 40 then
      returns median(a[0], a[n/2], a[n-1])
   else 
      returns median( median(a[0], a[s], a[2s])
                      median(a[n/2-s], a[n/2], a[n/2+s])
                      median(a[n-1-2s], a[n-1-s], a[n-1]) )
      where s = n / 8
   endif

   created -- 95nov25, cca
   ---------------------------------------------------------
*/
static double
centervalue (
   int      n,
   double   a[]
) {
int   i, j, k, s ;

j = n / 2 ;
if ( n > 7 ) {
   i = 0 ;
   k = n - 1 ;
   if ( n >= 40 ) {
      s = n / 8 ;
      i = median3(i, i+s, i+s+s, a) ;
      j = median3(j-s, j, j+s, a) ;
      k = median3(k-s-s, k-s, k, a) ;
   }
   j = median3(i, j, k, a) ;
}
return(a[j]) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   sort an array of doubles into ascending order using quick sort

   created -- 95nov25, cca
   ---------------------------------------------------------------
*/
void
DVqsortUp (
   int      n,
   double   dvec[]
) {
double   dtemp, v ;
int      a, b, c, d, l, h, s ;

if ( n <= 10 ) {
   DVisortUp(n, dvec) ;
} else {
   v = centervalue(n, dvec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && dvec[b] <= v ) {
         if ( dvec[b] == v ) {
            dtemp   = dvec[b] ;
            dvec[b] = dvec[a] ;
            dvec[a] = dtemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && dvec[c] >= v ) {
         if ( dvec[c] == v ) {
            dtemp   = dvec[c] ;
            dvec[c] = dvec[d] ;
            dvec[d] = dtemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      dtemp   = dvec[b] ;
      dvec[b] = dvec[c] ;
      dvec[c] = dtemp ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp ;
      l++ ;
      h++ ;
   }
   DVqsortUp(b - a, dvec) ;
   DVqsortUp(d - c, dvec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   sort an array of doubles into descending order using quick sort

   created -- 95sep29, cca
   ----------------------------------------------------------------
*/
void
DVqsortDown (
   int      n,
   double   dvec[]
) {
double   dtemp, v ;
int      a, b, c, d, l, h, s ;

if ( n <= 10 ) {
   DVisortDown(n, dvec) ;
} else {
   v = centervalue(n, dvec) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && dvec[b] >= v ) {
         if ( dvec[b] == v ) {
            dtemp   = dvec[b] ;
            dvec[b] = dvec[a] ;
            dvec[a] = dtemp   ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && dvec[c] <= v ) {
         if ( dvec[c] == v ) {
            dtemp   = dvec[c] ;
            dvec[c] = dvec[d] ;
            dvec[d] = dtemp   ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      dtemp   = dvec[b] ;
      dvec[b] = dvec[c] ;
      dvec[c] = dtemp ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      dtemp   = dvec[l] ;
      dvec[l] = dvec[h] ;
      dvec[h] = dtemp ;
      l++ ;
      h++ ;
   }
   DVqsortDown(b - a, dvec) ;
   DVqsortDown(d - c, dvec + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in ascending order.
   dvec1[] is the array of keys
   dvec2[] is the companion array

   example,
      dvec1[] = 5 8 3 2 9
      dvec2[] = 1 2 3 4 5
   becomes
      dvec1[] = 2 3 5 8 9
      dvec2[] = 4 3 1 2 5

   created -- 95sep29, cca
   ------------------------------------------
*/
void
DV2qsortUp (
   int      n,
   double   dvec1[],
   double   dvec2[]
) {
double   dtemp, v ;
int      a, b, c, d, l, h, s ;

if ( n <= 10 ) {
   DV2isortUp(n, dvec1, dvec2) ;
} else {
   v = centervalue(n, dvec1) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && dvec1[b] <= v ) {
         if ( dvec1[b] == v ) {
            dtemp    = dvec1[b] ;
            dvec1[b] = dvec1[a] ;
            dvec1[a] = dtemp    ;
            dtemp    = dvec2[b] ;
            dvec2[b] = dvec2[a] ;
            dvec2[a] = dtemp    ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && dvec1[c] >= v ) {
         if ( dvec1[c] == v ) {
            dtemp    = dvec1[c] ;
            dvec1[c] = dvec1[d] ;
            dvec1[d] = dtemp    ;
            dtemp    = dvec2[c] ;
            dvec2[c] = dvec2[d] ;
            dvec2[d] = dtemp    ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      dtemp    = dvec1[b] ;
      dvec1[b] = dvec1[c] ;
      dvec1[c] = dtemp    ;
      dtemp    = dvec2[b] ;
      dvec2[b] = dvec2[c] ;
      dvec2[c] = dtemp    ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      dtemp    = dvec1[l] ;
      dvec1[l] = dvec1[h] ;
      dvec1[h] = dtemp    ;
      dtemp    = dvec2[l] ;
      dvec2[l] = dvec2[h] ;
      dvec2[h] = dtemp    ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      dtemp    = dvec1[l] ;
      dvec1[l] = dvec1[h] ;
      dvec1[h] = dtemp    ;
      dtemp    = dvec2[l] ;
      dvec2[l] = dvec2[h] ;
      dvec2[h] = dtemp    ;
      l++ ;
      h++ ;
   }
   DV2qsortUp(b - a, dvec1, dvec2) ;
   DV2qsortUp(d - c, dvec1 + n - (d - c), dvec2 + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   use quick sort to sort a pair or arrays.
   on output the first is in descending order.
   dvec1[] is the array of keys
   dvec2[] is the companion array

   example,
      dvec1[] = 5 8 3 2 9
      dvec2[] = 1 2 3 4 5
   becomes
      dvec1[] = 9 8 5 3 2
      dvec2[] = 5 2 1 3 4

   created -- 95sep29, cca
   -------------------------------------------
*/
void
DV2qsortDown (
   int      n,
   double   dvec1[],
   double   dvec2[]
) {
double   dtemp, v ;
int      a, b, c, d, l, h, s ;

if ( n <= 10 ) {
   DV2isortDown(n, dvec1, dvec2) ;
} else {
   v = centervalue(n, dvec1) ;
   a = b = 0 ;
   c = d = n - 1 ;
   for ( ; ; ) {
      while ( b <= c && dvec1[b] >= v ) {
         if ( dvec1[b] == v ) {
            dtemp    = dvec1[b] ;
            dvec1[b] = dvec1[a] ;
            dvec1[a] = dtemp    ;
            dtemp    = dvec2[b] ;
            dvec2[b] = dvec2[a] ;
            dvec2[a] = dtemp    ;
            a++ ;
         }
         b++ ;
      }
      while ( c >= b && dvec1[c] <= v ) {
         if ( dvec1[c] == v ) {
            dtemp    = dvec1[c] ;
            dvec1[c] = dvec1[d] ;
            dvec1[d] = dtemp    ;
            dtemp    = dvec2[c] ;
            dvec2[c] = dvec2[d] ;
            dvec2[d] = dtemp    ;
            d-- ;
         }
         c-- ;
      }
      if ( b > c ) {
         break ;
      }
      dtemp    = dvec1[b] ;
      dvec1[b] = dvec1[c] ;
      dvec1[c] = dtemp    ;
      dtemp    = dvec2[b] ;
      dvec2[b] = dvec2[c] ;
      dvec2[c] = dtemp    ;
      b++ ;
      c-- ;
   }
   s = (a <= b - a) ? a : b - a ;
   for ( l = 0, h = b - s ; s != 0 ; s-- ) {
      dtemp    = dvec1[l] ;
      dvec1[l] = dvec1[h] ;
      dvec1[h] = dtemp    ;
      dtemp    = dvec2[l] ;
      dvec2[l] = dvec2[h] ;
      dvec2[h] = dtemp    ;
      l++ ;
      h++ ;
   }
   s = ((d - c) <= (n - 1 - d)) ? (d - c) : ( n - 1 - d) ;
   for ( l = b, h = n - s ; s != 0 ; s-- ) {
      dtemp    = dvec1[l] ;
      dvec1[l] = dvec1[h] ;
      dvec1[h] = dtemp    ;
      dtemp    = dvec2[l] ;
      dvec2[l] = dvec2[h] ;
      dvec2[h] = dtemp    ;
      l++ ;
      h++ ;
   }
   DV2qsortDown(b - a, dvec1, dvec2) ;
   DV2qsortDown(d - c, dvec1 + n - (d - c), dvec2 + n - (d - c)) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   return 1 if elements in array are in ascending order
   return 0 otherwise

   created -- 95nov25, cca
   ----------------------------------------------------
*/
int
DVisascending (
   int      n,
   double   dvec[]
) {
if ( n <= 0 ) {
   return(0) ;
} else if ( n == 1 ) {
   return(1) ;
} else {
   int   i ;
   for ( i = 1 ; i < n ; i++ ) {
      if ( dvec[i-1] > dvec[i] ) {
         return(0) ;
      }
   }
   return(1) ;
}
}
/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   return 1 if elements in array are in descending order
   return 0 otherwise

   created -- 95sep29, cca
   -----------------------------------------------------
*/
int
DVisdescending (
   int      n,
   double   dvec[]
) {
if ( n <= 0 ) {
   return(0) ;
} else if ( n == 1 ) {
   return(1) ;
} else {
   int   i ;
   for ( i = 1 ; i < n ; i++ ) {
      if ( dvec[i-1] < dvec[i] ) {
         return(0) ;
      }
   }
   return(1) ;
}
}
/*--------------------------------------------------------------------*/
