/*  testIVsortUpAndCompress.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   ---------------------------------------------------------
   purpose -- to test the IVsortUpAndCompress method

   created -- 97dec18, cca

   usage : testIVsortUpAndCompress msglvl msgFile n mod seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   n       -- length of vector(s)
   mod     -- entries in vectors are uniform(0,n-1) % mod
   seed    -- seed for random number generator
   ---------------------------------------------------------
*/
{
double   t1, t2 ;
Drand    drand ;
FILE     *msgFile ;
int      ii, ierr, msglvl, mod, n, nnew, seed ;
int      *ivec1 ;

if ( argc != 6 ) {
   fprintf(stdout, 
         "\n usage : %s msglvl msgFile n mod seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   n       -- length of vector"
         "\n   mod     -- entries in vectors are uniform(0,n-1) %% mod"
         "\n   seed    -- seed for random number generator"
         "\n", argv[0]) ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
n    = atoi(argv[3]) ;
mod  = atoi(argv[4]) ;
seed = atoi(argv[5]) ;
/*
   ------------------------------------
   check the IVsortUpAndCompress method
   ------------------------------------
*/
Drand_setDefaultFields(&drand) ;
ivec1 = IVinit2(n) ;
Drand_setSeed(&drand, seed) ;
Drand_setUniform(&drand, 0, n-1) ;
Drand_fillIvector(&drand, n, ivec1) ;
for ( ii = 0 ; ii < n ; ii++ ) {
   ivec1[ii] = ivec1[ii] % mod ;
}
if ( msglvl > 1 ) {
fprintf(msgFile, "\n initial vector") ;
IVfp80(msgFile, n, ivec1, 80, &ierr) ;
fprintf(msgFile, "\n ") ;
fflush(msgFile) ;
}
MARKTIME(t1) ;
nnew = IVsortUpAndCompress(n, ivec1) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : sort and compress %d integers \n",
        t2 - t1, n) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n nnew = %d, sorted and compressed vector", nnew);
   IVfp80(msgFile, nnew, ivec1, 80, &ierr) ;
   fprintf(msgFile, "\n ") ;
}
if ( IVisascending(nnew, ivec1) == 0 ) {
   fprintf(msgFile, "\n fatal error after IVsortUpAndCompress\n") ;
} else {
   fprintf(msgFile, "\n success from IVsortUpAndCompress\n") ;
}

exit(0) ; }

/*--------------------------------------------------------------------*/
