/*  testIVsort.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   ------------------------------------------------------
   purpose -- to test the integer sort routines

   created -- 95sep28, cca

   usage : testIVsort msglvl msgFile sortType n mod seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   sortType -- type of sort
      1 -- ascending insert sort
      2 -- descending insert sort
      3 -- ascending insert sort with a companion vector
      4 -- descending insert sort with a companion vector
      5 -- ascending quick sort
      6 -- descending quick sort
      7 -- ascending quick sort with a companion vector
      8 -- descending quick sort with a companion vector
   n    -- length of vector(s)
   mod  -- entries in vectors are uniform(0,n-1) % mod
   seed -- seed for random number generator
   ------------------------------------------------------
*/
{
double   t1, t2 ;
Drand    drand ;
FILE     *msgFile ;
int      i, ierr, msglvl, mod, n, seed, sortType ;
int      *ivec1, *ivec2 ;

if ( argc != 7 ) {
   fprintf(stdout, 
         "\n usage : testIVsort msglvl msgFile sortType n mod seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   sortType -- type of sort"
         "\n      1 -- ascending insert sort"
         "\n      2 -- descending insert sort"
         "\n      3 -- ascending insert sort with a companion vector"
         "\n      4 -- descending insert sort with a companion vector"
         "\n      5 -- ascending quick sort"
         "\n      6 -- descending quick sort"
         "\n      7 -- ascending quick sort with a companion vector"
         "\n      8 -- descending quick sort with a companion vector"
         "\n   n    -- length of vector(s)"
         "\n   mod  -- entries in vectors are uniform(0,n-1) %% mod"
         "\n   seed -- seed for random number generator"
         "\n") ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
sortType = atoi(argv[3]) ;
n        = atoi(argv[4]) ;
mod      = atoi(argv[5]) ;
seed     = atoi(argv[6]) ;
/*
   -------------------------
   switch over the sort type
   -------------------------
*/
Drand_setDefaultFields(&drand) ;
switch ( sortType ) {
case 1 :
/*
   --------------------------
   insert sort up, one vector
   --------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n insert sort up, single vector") ;
      fprintf(msgFile, "\n initial vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IVisortUp(n, ivec1) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IVisortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisascending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IVisortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from IVisortUp\n") ;
   }
   IVfree(ivec1) ;
   break ;
case 2 :
/*
   ----------------------------
   insert sort down, one vector
   ----------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n insert sort down, single vector") ;
      fprintf(msgFile, "\n initial vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IVisortDown(n, ivec1) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IVisortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisdescending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after insert IVisortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from IVisortDown\n") ;
   }
   IVfree(ivec1) ;
   break ;
case 3 :
/*
   ---------------------------
   insert sort up, two vectors
   ---------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   ivec2 = IVinit2(n) ;
   IVramp(n, ivec2, 0, 1) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n insert sort up, two vectors") ;
      fprintf(msgFile, "\n key vector ") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n index vector ") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IV2isortUp(n, ivec1, ivec2) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IV2isortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted key vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n sorted index vector") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisascending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IV2isortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from IV2isortUp\n") ;
   }
   IVfree(ivec1) ;
   IVfree(ivec2) ;
   break ;
case 4 :
/*
   -----------------------------
   insert sort down, two vectors
   -----------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   ivec2 = IVinit2(n) ;
   IVramp(n, ivec2, 0, 1) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n insert sort down, two vectors") ;
      fprintf(msgFile, "\n key vector ") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n index vector ") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IV2isortDown(n, ivec1, ivec2) ;
   MARKTIME(t2) ;
   fprintf(msgFile, 
           "\n CPU %9.5f : sort %d integers via IV2isortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted key vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n sorted index vector") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisdescending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IV2isortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from IV2isortDown\n") ;
   }
   IVfree(ivec1) ;
   IVfree(ivec2) ;
   break ;
case 5 :
/*
   -------------------------
   quick sort up, one vector
   -------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n case 5 : quick sort up, single vector") ;
      fprintf(msgFile, "\n initial vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IVqsortUp(n, ivec1) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IVqsortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisascending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IVqsortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from IVqsortUp\n") ;
   }
/*
   IVfree(ivec1) ;
*/
   break ;
case 6 :
/*
   ---------------------------
   quick sort down, one vector
   ---------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n quick sort down, single vector") ;
      fprintf(msgFile, "\n initial vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IVqsortDown(n, ivec1) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IVqsortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisdescending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after insert IVqsortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from IVqsortDown\n") ;
   }
   IVfree(ivec1) ;
   break ;
case 7 :
/*
   --------------------------
   quick sort up, two vectors
   --------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   ivec2 = IVinit2(n) ;
   IVramp(n, ivec2, 0, 1) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n quick sort up, two vectors") ;
      fprintf(msgFile, "\n key vector ") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n index vector ") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IV2qsortUp(n, ivec1, ivec2) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d integers via IV2qsortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted key vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n sorted index vector") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisascending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IV2qsortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from IV2qsortUp\n") ;
   }
   IVfree(ivec1) ;
   IVfree(ivec2) ;
   break ;
case 8 :
/*
   ----------------------------
   quick sort down, two vectors
   ----------------------------
*/
   ivec1 = IVinit2(n) ;
   Drand_setSeed(&drand, seed) ;
   Drand_setUniform(&drand, 0, n-1) ;
   Drand_fillIvector(&drand, n, ivec1) ;
   for ( i = 0 ; i < n ; i++ ) {
      ivec1[i] = ivec1[i] % mod ;
   }
   ivec2 = IVinit2(n) ;
   IVramp(n, ivec2, 0, 1) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n quick sort down, two vectors") ;
      fprintf(msgFile, "\n key vector ") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n index vector ") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   MARKTIME(t1) ;
   IV2qsortDown(n, ivec1, ivec2) ;
   MARKTIME(t2) ;
   fprintf(msgFile, 
           "\n CPU %9.5f : sort %d integers via IV2qsortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted key vector") ;
      IVfp80(msgFile, n, ivec1, 80, &ierr) ;
      fprintf(msgFile, "\n sorted index vector") ;
      IVfp80(msgFile, n, ivec2, 80, &ierr) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( IVisdescending(n, ivec1) == 0 ) {
      fprintf(msgFile, "\n fatal error after IV2qsortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from IV2qsortDown\n") ;
   }
   IVfree(ivec1) ;
   IVfree(ivec2) ;
   break ;
default :
   fprintf(stderr, "\n inside testIVsort, invalid sortType") ;
   exit(-1) ;
}

exit(0) ; }

/*--------------------------------------------------------------------*/
