/*  testIVDVsortUpAndCompress.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   ------------------------------------------------------
   purpose -- to test the IVDVsortUpAndCompress

   created -- 97dec18, cca

   usage : testIVutil msglvl msgFile n mod seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   n       -- length of vector(s)
   mod     -- entries in vectors are uniform(0,n-1) % mod
   seed    -- seed for random number generator
   ------------------------------------------------------
*/
{
double   t1, t2 ;
double   *dvec1, *dvec2 ;
Drand    drand ;
FILE     *msgFile ;
int      ii, jj, key1, msglvl, mod, n, nnew, seed ;
int      *ivec1, *ivec2 ;

if ( argc != 6 ) {
   fprintf(stdout, 
         "\n usage : %s msglvl msgFile n mod seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   n       -- length of vector"
         "\n   mod     -- entries in vectors are uniform(0,n-1) %% mod"
         "\n   seed    -- seed for random number generator"
         "\n", argv[0]) ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
n    = atoi(argv[3]) ;
mod  = atoi(argv[4]) ;
seed = atoi(argv[5]) ;
/*
   -------------------------------------
   check the IDVsortUpAndCompress method
   -------------------------------------
*/
ivec1 = IVinit2(n) ;
ivec2 = IVinit2(n) ;
dvec1 = DVinit2(n) ;
dvec2 = DVinit2(n) ;
Drand_setDefaultFields(&drand) ;
Drand_setSeed(&drand, seed) ;
Drand_setUniform(&drand, 0, n-1) ;
Drand_fillIvector(&drand, n, ivec1) ;
DVfill(n, dvec1, 1.0) ;
Drand_fillDvector(&drand, n, dvec1) ;
IVcopy(n, ivec2, ivec1) ;
DVcopy(n, dvec2, dvec1) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n %d initial pairs", n) ;
   for ( ii = 0 ; ii < n ; ii++ ) {
      fprintf(msgFile, "\n < %12d, %12.4e >", ivec1[ii], dvec1[ii]) ;
   }
fflush(msgFile) ;
}
MARKTIME(t1) ;
nnew = IVDVsortUpAndCompress(n, ivec1, dvec1) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : IVDVsortUpAndCompress time", t2 - t1) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n %d final pairs", nnew) ;
   for ( ii = 0 ; ii < nnew ; ii++ ) {
      fprintf(msgFile, "\n < %12d, %12.4e >", ivec1[ii], dvec1[ii]) ;
   }
   fflush(msgFile) ;
}
for ( ii = 0 ; ii < n ; ii++ ) {
   key1 = ivec2[ii] ;
   for ( jj = 0 ; jj < nnew ; jj++ ) {
      if ( key1 == ivec1[jj] ) {
         dvec1[jj] -= dvec2[ii] ;
         break ;
      }
   }
   if ( jj == nnew ) {
      fprintf(msgFile, "\n pair < %d,%f> not found", 
              ivec2[ii], dvec2[ii]) ;
   }
}
fprintf(msgFile, "\n error norm = %12.4e", DVmaxabs(nnew, dvec1, &ii)) ;
fprintf(msgFile, "\n dvec1[]") ;
DVfprintf(msgFile, nnew, dvec1) ;

exit(0) ; }

/*--------------------------------------------------------------------*/
