/*  testIV2DVsortUpAndCompress.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   ----------------------------------------------------------
   purpose -- to test the testIV2DVsortUpAndCompress routines

   created -- 97dec18, cca

   usage : testIVutil msglvl msgFile n mod seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   n       -- length of vector(s)
   mod     -- entries in vectors are uniform(0,n-1) % mod
   seed    -- seed for random number generator
   ----------------------------------------------------------
*/
{
double   t1, t2 ;
double   *dvec1, *dvec2 ;
Drand    drand ;
FILE     *msgFile ;
int      ii, jj, key1, key2, msglvl, mod, n, nnew, seed ;
int      *ivec1, *ivec2, *ivec3, *ivec4 ;

if ( argc != 6 ) {
   fprintf(stdout, 
         "\n usage : %s msglvl msgFile n mod seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   n       -- length of vector"
         "\n   mod     -- entries in vectors are uniform(0,n-1) %% mod"
         "\n   seed    -- seed for random number generator"
         "\n", argv[0]) ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
n    = atoi(argv[3]) ;
mod  = atoi(argv[4]) ;
seed = atoi(argv[5]) ;
/*
   ---------------------------------------
   check the IV2DVsortUpAndCompress method
   ---------------------------------------
*/
Drand_setDefaultFields(&drand) ;
ivec1 = IVinit2(n) ;
ivec2 = IVinit2(n) ;
ivec3 = IVinit2(n) ;
ivec4 = IVinit2(n) ;
dvec1 = DVinit2(n) ;
dvec2 = DVinit2(n) ;
Drand_setSeed(&drand, seed) ;
Drand_setUniform(&drand, 0, n-1) ;
Drand_fillIvector(&drand, n, ivec1) ;
Drand_fillIvector(&drand, n, ivec2) ;
Drand_fillDvector(&drand, n, dvec1) ;
for ( ii = 0 ; ii < n ; ii++ ) {
   ivec1[ii] = ivec1[ii] % mod ;
   ivec2[ii] = ivec2[ii] % mod ;
   ivec3[ii] = ivec1[ii] ;
   ivec4[ii] = ivec2[ii] ;
   dvec2[ii] = dvec1[ii] ;
}
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n %d initial triples", n) ;
   for ( ii = 0 ; ii < n ; ii++ ) {
      fprintf(msgFile, "\n < %12d, %12d, %12.4e >", 
              ivec1[ii], ivec2[ii], dvec1[ii]) ;
   }
   fflush(msgFile) ;
}
MARKTIME(t1) ;
nnew = IV2DVsortUpAndCompress(n, ivec1, ivec2, dvec1) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : IV2DVsortUpAndCompress", t2 - t1) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n %d sorted and compressed triples", nnew) ;
   for ( ii = 0 ; ii < nnew ; ii++ ) {
      fprintf(msgFile, "\n < %12d, %12d, %12.4e >", 
              ivec1[ii], ivec2[ii], dvec1[ii]) ;
   }
   fflush(msgFile) ;
}
for ( ii = 0 ; ii < n ; ii++ ) {
   key1 = ivec3[ii] ;
   key2 = ivec4[ii] ;
   for ( jj = 0 ; jj < nnew ; jj++ ) {
      if ( key1 == ivec1[jj] && key2 == ivec2[jj] ) {
         if ( msglvl > 1 ) {
            fprintf(msgFile, "\n <%d,%d> found in entry %d",
                    key1, key2, jj) ;
         }
         dvec1[jj] -= dvec2[ii] ;
         break ;
      }
   }
   if ( jj == nnew ) {
      fprintf(msgFile, "\n error, <%d,%d> not found in compressed list",
              key1, key2) ;
   }
}
fprintf(msgFile, "\n max error = %12.4e\n", 
        DVmaxabs(nnew, dvec1, &ii)) ;
if ( msglvl > 1 ) {
   DVfprintf(msgFile, nnew, dvec1) ;
}

exit(0) ; }

/*--------------------------------------------------------------------*/
