/*  testDVIVsort.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   -------------------------------------------------------
   purpose -- to test the (double,integer) sort routines

   created -- 97apr03, cca

   usage : testDVIVsort msglvl msgFile sortType n mod seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   sortType -- type of sort
      1 -- ascending insert sort
      2 -- descending insert sort
      3 -- ascending quick sort
      4 -- descending quick sort
   n    -- length of vector(s)
   mod  -- entries in vectors are uniform(0,n-1) % mod
   seed -- seed for random number generator
   -------------------------------------------------------
*/
{
double   t1, t2 ;
double   *dvec ;
Drand    drand ;
FILE     *msgFile ;
int      ierr, msglvl, mod, n, seed, sortType ;
int      *ivec ;

if ( argc != 7 ) {
   fprintf(stdout, 
         "\n usage : testDVIVsort msglvl msgFile sortType n mod seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   sortType -- type of sort"
         "\n      1 -- ascending insert sort"
         "\n      2 -- descending insert sort"
         "\n      3 -- ascending quick sort"
         "\n      4 -- descending quick sort"
         "\n   n    -- length of vector(s)"
         "\n   mod  -- entries in vectors are uniform(0,n-1) %% mod"
         "\n   seed -- seed for random number generator"
         "\n") ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
sortType = atoi(argv[3]) ;
n        = atoi(argv[4]) ;
mod      = atoi(argv[5]) ;
seed     = atoi(argv[6]) ;
/*
   -------------------------
   switch over the sort type
   -------------------------
*/
Drand_setDefaultFields(&drand) ;
ivec = IVinit2(n) ;
dvec = DVinit2(n) ;
Drand_setSeed(&drand, seed) ;
Drand_setUniform(&drand, 0, n-1) ;
Drand_fillIvector(&drand, n, ivec) ;
IVramp(n, ivec, 0, 1) ;
Drand_fillDvector(&drand, n, dvec) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n initial int vector") ;
   IVfp80(msgFile, n, ivec, 80, &ierr) ;
   fprintf(msgFile, "\n initial double vector") ;
   DVfprintf(msgFile, n, dvec) ;
   fprintf(msgFile, "\n ") ;
   fflush(msgFile) ;
}
switch ( sortType ) {
case 1 :
/*
   --------------
   insert sort up
   --------------
*/
   MARKTIME(t1) ;
   DVIVisortUp(n, dvec, ivec) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d entries via DVIVisortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted int vector") ;
      IVfp80(msgFile, n, ivec, 80, &ierr) ;
      fprintf(msgFile, "\n sorted int vector") ;
      DVfprintf(msgFile, n, dvec) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( DVisascending(n, dvec) == 0 ) {
      fprintf(msgFile, "\n fatal error after DVIVisortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from DVIVisortUp\n") ;
   }
   break ;
case 2 :
/*
   ----------------
   insert sort down
   ----------------
*/
   MARKTIME(t1) ;
   DVIVisortDown(n, dvec, ivec) ;
   MARKTIME(t2) ;
   fprintf(msgFile, 
           "\n CPU %9.5f : sort %d entries via DVIVisortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted int vector") ;
      IVfp80(msgFile, n, ivec, 80, &ierr) ;
      fprintf(msgFile, "\n sorted int vector") ;
      DVfprintf(msgFile, n, dvec) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( DVisdescending(n, dvec) == 0 ) {
      fprintf(msgFile, "\n fatal error after DVIVisortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from DVIVisortDown\n") ;
   }
   break ;
case 3 :
/*
   -------------
   quick sort up
   -------------
*/
   MARKTIME(t1) ;
   DVIVqsortUp(n, dvec, ivec) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : sort %d entries via DVIVqsortUp\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted int vector") ;
      IVfp80(msgFile, n, ivec, 80, &ierr) ;
      fprintf(msgFile, "\n sorted int vector") ;
      DVfprintf(msgFile, n, dvec) ;
      fprintf(msgFile, "\n ") ;
   }
   if ( DVisascending(n, dvec) == 0 ) {
      fprintf(msgFile, "\n fatal error after DVIVqsortUp\n") ;
   } else {
      fprintf(msgFile, "\n success from DVIVqsortUp\n") ;
   }
   break ;
case 4 :
/*
   ---------------
   quick sort down
   ---------------
*/
   MARKTIME(t1) ;
   DVIVqsortDown(n, dvec, ivec) ;
   MARKTIME(t2) ;
   fprintf(msgFile, 
           "\n CPU %9.5f : sort %d entries via DVIVqsortDown\n",
           t2 - t1, n) ;
   if ( msglvl > 1 ) {
      fprintf(msgFile, "\n sorted int vector") ;
      IVfp80(msgFile, n, ivec, 80, &ierr) ;
      fprintf(msgFile, "\n sorted int vector") ;
      DVfprintf(msgFile, n, dvec) ;
      fprintf(msgFile, "\n ") ;
      fflush(msgFile) ;
   }
   if ( DVisdescending(n, dvec) == 0 ) {
      fprintf(msgFile, "\n fatal error after DVIVisortDown\n") ;
   } else {
      fprintf(msgFile, "\n success from DVIVisortDown\n") ;
   }
   break ;
default :
   fprintf(stderr, "\n inside testDVIVsort, invalid sortType") ;
   exit(-1) ;
}
DVfree(dvec) ;
IVfree(ivec) ;

exit(0) ; }

/*--------------------------------------------------------------------*/
