/*  testBucketSort.c  */

#include "../Utilities.h"
#include "../../Drand.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
int
main ( int argc, char *argv[] )
/*
   ------------------------------------------------------
   purpose -- to test the bucket sort routines

   created -- 95sep28, cca

   usage : testBucketSort msglvl msgFile nent n seed

   msglvl -- message level
      msglvl == 1 --> just timings
      msglvl >  1 --> vector(s) before and after sort
   msgFile -- message file
   nent    -- length of vectors to be sorted
   n       -- maximum entry
   seed    -- seed for random number generator
   ------------------------------------------------------
*/
{
double   buckettime, countstime, inserttime, offsetstime,
         quicksorttime, t1, t2, zerotime ;
double   *dvec1, *dvec2 ;
Drand    drand ;
FILE     *msgFile ;
int      count, ii, ierr, j, kk, msglvl, n, nent, seed, size ;
int      *ivec1, *ivec2, *ivec3, *ivec4, *offsets ;

if ( argc != 6 ) {
   fprintf(stdout, 
         "\n usage : testIVsort msglvl msgFile nent n seed"
         "\n   msglvl -- message level"
         "\n      msglvl == 1 --> just timings"
         "\n      msglvl >  1 --> vector(s) before and after sort"
         "\n   msgFile -- message file"
         "\n   nent    -- length of vectors to be sorted"
         "\n   n       -- maximum entry"
         "\n   seed    -- seed for random number generator"
         "\n") ;
   exit(0) ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp("stdout", argv[2]) == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   exit(-1) ;
}
nent   = atoi(argv[3]) ;
n      = atoi(argv[4]) ;
seed   = atoi(argv[5]) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n nent = %d, N = %d, seed = %d",
           nent, n, seed) ;
   fflush(stdout) ;
}
/*
   --------------------------------------
   initialize the random number generator
   --------------------------------------
*/
Drand_setDefaultFields(&drand) ;
Drand_setSeed(&drand, seed) ;
/*
   ---------------
   get the vectors
   ---------------
*/
Drand_setUniform(&drand, 0, n-1) ;
ivec1 = IVinit2(nent) ;
Drand_fillIvector(&drand, nent, ivec1) ;
ivec2 = IVinit2(nent) ;
Drand_fillIvector(&drand, nent, ivec2) ;
dvec1 = DVinit2(nent) ;
Drand_setNormal(&drand, 0.0, 1.0) ;
Drand_fillDvector(&drand, nent, dvec1) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n vectors prior to sort") ;
   fprintf(msgFile, "\n ivec1") ;
   IVfp80(msgFile, nent, ivec1, 80, &ierr) ;
   fprintf(msgFile, "\n ivec2") ;
   IVfp80(msgFile, nent, ivec2, 80, &ierr) ;
   fprintf(msgFile, "\n dvec1") ;
   DVfprintf(msgFile, nent, dvec1) ;
   fflush(stdout) ;
}
ivec3 = IVinit2(nent) ;
ivec4 = IVinit2(nent) ;
dvec2 = DVinit2(nent) ;
/*
   ---------------
   get the offsets
   ---------------
*/
offsets = IVinit2(n) ;
MARKTIME(t1) ;
for ( ii = 0 ; ii < n ; ii++ ) {
   offsets[ii] = 0 ;
}
MARKTIME(t2) ;
zerotime = t2 - t1 ;
MARKTIME(t1) ;
for ( ii = 0 ; ii < nent ; ii++ ) {
   j = ivec1[ii] ;
   offsets[j]++ ;
}
MARKTIME(t2) ;
countstime = t2 - t1 ;
MARKTIME(t1) ;
for ( ii = 0, size = 0 ; ii < n ; ii++ ) {
   count = offsets[ii] ;
   offsets[ii] = size ;
   size += count ;
}
MARKTIME(t2) ;
offsetstime = t2 - t1 ;
MARKTIME(t1) ;
for ( ii = 0 ; ii < nent ; ii++ ) {
   j = ivec1[ii] ;
   kk = offsets[j]++ ;
   ivec3[kk] = j ;
   ivec4[kk] = ivec2[ii] ;
   dvec2[kk] = dvec1[ii] ;
}
MARKTIME(t2) ;
inserttime = t2 - t1 ;
buckettime = zerotime + countstime + offsetstime + inserttime ;
fprintf(msgFile, "\n CPU %9.5f : total bucket sort time", 
        buckettime) ;
fprintf(msgFile, "\n    CPU %9.5f : zero offsets ", zerotime) ;
fprintf(msgFile, "\n    CPU %9.5f : compute counts", countstime) ;
fprintf(msgFile, "\n    CPU %9.5f : compute offsets", offsetstime) ;
fprintf(msgFile, "\n    CPU %9.5f : put into buckets", inserttime) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n sorted vectors via bucket sort") ;
   fprintf(msgFile, "\n ivec3") ;
   IVfp80(msgFile, nent, ivec3, 80, &ierr) ;
   fprintf(msgFile, "\n ivec4") ;
   IVfp80(msgFile, nent, ivec4, 80, &ierr) ;
   fprintf(msgFile, "\n dvec2") ;
   DVfprintf(msgFile, nent, dvec2) ;
   fflush(stdout) ;
}
/*
   -------------------
   now do a quick sort
   -------------------
*/
MARKTIME(t1) ;
IV2DVqsortUp(nent, ivec1, ivec2, dvec1) ;
MARKTIME(t2) ;
quicksorttime = t2 - t1 ;
fprintf(msgFile, "\n CPU %9.5f : quicksort time", quicksorttime) ;
if ( msglvl > 1 ) {
   fprintf(msgFile, "\n sorted vectors via quick sort") ;
   fprintf(msgFile, "\n ivec1") ;
   IVfp80(msgFile, nent, ivec1, 80, &ierr) ;
   fprintf(msgFile, "\n ivec2") ;
   IVfp80(msgFile, nent, ivec2, 80, &ierr) ;
   fprintf(msgFile, "\n dvec1") ;
   DVfprintf(msgFile, nent, dvec1) ;
   fflush(stdout) ;
}

exit(0) ; }

/*--------------------------------------------------------------------*/
