/*  I2P.h  */

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   the I2P structure contains two Int fields and an I2P* field.
   it is the simplest singly linked list element, useful at times.
   ---------------------------------------------------------------
*/
typedef struct _I2P I2P ;
struct _I2P {
   int   value0 ;
   int   value1 ;
   I2P   *next  ;
} ;
/*--------------------------------------------------------------------*/

#define I2P_NULL     0
#define I2P_FORWARD  1
#define I2P_BACKWARD 2

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------
   initializer. 
   create and return an array of n I2P structures.
   the structures are linked in one of three ways.
   flag = 0 (I2P_NULL)     --> ip->next = NULL
   flag = 1 (I2P_FORWARD)  --> ip->next = successor in list
   flag = 2 (I2P_BACKWARD) --> ip->next = predecessor in list
   
   created -- 96nov02, cca
   ---------------------------------------------------------
*/
I2P *
I2P_init ( 
   int   n, 
   int   flag 
) ;
/*
   ---------------------------------------------------------
   initializer. 
   create and return an array of n I2P structures.
   the structures are linked in one of three ways.
   flag = 0 (I2P_NULL)     --> ip->next = NULL
   flag = 1 (I2P_FORWARD)  --> ip->next = successor in list
   flag = 2 (I2P_BACKWARD) --> ip->next = predecessor in list
   
   created -- 96nov02, cca
   ---------------------------------------------------------
*/
void
I2P_initStorage ( 
   int   n, 
   int   flag,
   I2P   *base
) ;
/*
   -----------------------------------------------
   free the storage for an array of I2P structures,
   must have been allocated by I2P_init

   created -- 96nov02, cca
   -----------------------------------------------
*/
void
I2P_free ( 
   I2P   *ip
) ;
/*
   ----------------------------------
   purpose -- to print out a I2P list
   
   created -- 96nov02, cca
   ----------------------------------
*/
void
I2P_fprintf ( 
   FILE   *fp, 
   I2P    *elem 
) ;
/*
   ------------------------------------------------------------------
   purpose -- to write out an integer list with eighty column lines

   input --

      fp     -- file pointer, must be formatted and write access
      elem   -- head of list
      column -- present column
  
   return value -- present column
   
   created -- 96nov02, cca
   ------------------------------------------------------------------
*/
int
I2P_fp80 ( 
   FILE   *fp, 
   I2P    *elem, 
   int    column 
) ;
/*--------------------------------------------------------------------*/
