/*  SymbFac.h  */

#include "../ETree.h"
#include "../Graph.h"
#include "../DInpMtx.h"
#include "../DPencil.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   purpose -- using one graph, create and return an IVL object 
              that contains a symbolic factorization.

   created -- 97aug29, cca
   -----------------------------------------------------------
*/
IVL *
SymbFac_initFromGraph (
   ETree   *etree,
   Graph   *graph
) ;
/*
   -------------------------------------------------------
   purpose -- create and return an IVL object that 
              contains a symbolic factorization.
   note: we assume that both the ETree and DInpMtx objects
         are in their final permutation

   created -- 97mar15, cca
   -------------------------------------------------------
*/
IVL *
SymbFac_initFromDInpMtx (
   ETree     *etree,
   DInpMtx   *inpmtx
) ;
/*
   -----------------------------------------------------
   compute the symbolic factorization of a matrix pencil

   created -- 97jul28, cca
   -----------------------------------------------------
*/
IVL *
SymbFac_initFromDPencil (
   ETree     *etree,
   DPencil   *pencil
) ;
/*--------------------------------------------------------------------*/
