/*  setupPencil.c  */

#include "../spoolesMPI.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------------
   purpose -- to split a distributed DPencil object

   pencil     -- pointer to the local DPencil object
   mapIV      -- pointer to the map from vertices to processes
   firsttag   -- first tag value, two will be used, tag and tag+1
   stats[4]    -- statistics vector
      stats[0] -- # of messages sent
      stats[1] -- # of messages received
      stats[2] -- # of bytes sent
      stats[3] -- # of bytes received
   msglvl     -- local message level
   msgFile    -- local message file
   comm       -- MPI communication structure
 
   created  -- 97jul18, cca
   modified -- 97oct17, cca
      stats added
   -------------------------------------------------------------------
*/
void
DPencil_MPI_split (
   DPencil    *pencil,
   IV         *mapIV,
   int        firsttag,
   int        stats[],
   int        msglvl,
   FILE       *msgFile,
   MPI_Comm   comm
) {
DInpMtx   *inpmtxA, *inpmtxB, *keepmtx ;
int       flag, tag, tag_bound ;
/*
   -----------------------
   check the range of tags
   -----------------------
*/
MPI_Attr_get(MPI_COMM_WORLD, MPI_TAG_UB, &tag_bound, &flag) ;
if ( firsttag < 0 || firsttag + 1 > tag_bound ) {
   fprintf(stderr, "\n fatal error in DPencil_MPI_split()"
           "\n range of tags is [%d,%d], tag_bound = %d",
           firsttag, firsttag + 1, tag_bound) ;
   exit(-1) ;
}
/*
   ------------------------------------
   split the DInpMtx object into pieces
   ------------------------------------
*/
tag = firsttag ;
if ( (inpmtxA = pencil->inpmtxA) != NULL ) {
   keepmtx = DInpMtx_MPI_split(inpmtxA, mapIV, tag, stats,
                              msglvl, msgFile, comm) ;
   DInpMtx_free(inpmtxA) ;
   pencil->inpmtxA = keepmtx ;
}
tag += 1 ;
if ( (inpmtxB = pencil->inpmtxB) != NULL ) {
   keepmtx = DInpMtx_MPI_split(inpmtxB, mapIV, tag, stats,
                              msglvl, msgFile, comm) ;
   DInpMtx_free(inpmtxB) ;
   pencil->inpmtxB = keepmtx ;
}
tag += 1 ;

return ; }

/*--------------------------------------------------------------------*/
