/*  writeMetisFile.c  */

#include "../Graph.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -------------------------------------------------
   read in a graph and write it out as a Metis File

   created -- 97apr03, cca
   -------------------------------------------------
*/
{
char     *inGraphFileName, *outGraphFileName ;
double   t1, t2 ;
FILE     *fp, *msgFile ;
int      msglvl, rc ;
Graph    *g ;

if ( argc != 5 ) {
   fprintf(stdout, 
      "\n\n usage : %s msglvl msgFile inFile outFile"
      "\n    msglvl   -- message level"
      "\n    msgFile  -- message file"
      "\n    inFile   -- input file, must be *.graphf or *.graphb"
      "\n    outFile  -- output file for a metis file"
      "\n", argv[0]) ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
inGraphFileName  = argv[3] ;
outGraphFileName = argv[4] ;
fprintf(msgFile, 
        "\n %s "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n inFile   -- %s" 
        "\n outFile  -- %s" 
        "\n",
        argv[0], msglvl, argv[2], inGraphFileName, outGraphFileName) ;
fflush(msgFile) ;
/*
   ----------------------
   read in the Graph object
   ----------------------
*/
if ( strcmp(inGraphFileName, "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
g = Graph_new() ;
MARKTIME(t1) ;
rc = Graph_readFromFile(g, inGraphFileName) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in graph from file %s",
        t2 - t1, inGraphFileName) ;
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from Graph_readFromFile(%p,%s)",
           rc, g, inGraphFileName) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading Graph object from file %s",
        inGraphFileName) ;
if ( msglvl > 2 ) {
   Graph_writeForHumanEye(g, msgFile) ;
} else {
   Graph_writeStats(g, msgFile) ;
}
fflush(msgFile) ;
/*
   --------------------------
   write out the Graph object
   --------------------------
*/
if ( strcmp(outGraphFileName, "none") != 0 ) {
   if ( (fp = fopen(outGraphFileName, "w")) == NULL ) {
      fprintf(stderr, "\n fatal error in %s"
              "\n unable to open file %s\n",
              argv[0], outGraphFileName) ;
      return ;
   }
   MARKTIME(t1) ;
   rc = Graph_writeToMetisFile(g, fp) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : write graph to file %s",
           t2 - t1, outGraphFileName) ;
   if ( rc != 1 ) {
      fprintf(msgFile, 
              "\n return value %d from Graph_writeToMetisFile(%p,%s)",
              rc, g, outGraphFileName) ;
   }
}
/*
   ---------------------
   free the Graph object
   ---------------------
*/
Graph_free(g) ;

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
