/*  ms.c  */

#include "../ETree.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------
   returns a compidsIV IV object that maps the
   vertices to a domain (compids[v] > 1)
   or to the multisector (compids[v] = 0).
   the vertices in the multisector is specified 
   by their depth of their front in the tree.

   created -- 96jan04, cca
   ------------------------------------------------
*/
IV *
ETree_msByDepth (
   ETree   *etree,
   int     depth
) {
int    front, nfront, nvtx, v ;
int    *compids, *dmetric, *vtxToFront ;
IV     *compidsIV, *vmetricIV, *dmetricIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (   etree == NULL 
   || (nfront = etree->nfront) <= 0
   || (nvtx = etree->nvtx) <= 0
   || depth <= 0 ) {
   fprintf(stderr, "\n fatal error in ETree_msByDepth(%p,%d)"
           "\n bad input\n", etree, depth) ;
   exit(-1) ;
}
vtxToFront = IV_entries(etree->vtxToFrontIV) ;
/*
   --------------------
   get the depth metric
   --------------------
*/
vmetricIV = IV_new() ;
IV_init(vmetricIV, nfront, NULL) ;
IV_fill(vmetricIV, 1) ;
dmetricIV = Tree_setDepthImetric(etree->tree, vmetricIV) ;
dmetric   = IV_entries(dmetricIV) ;
#if MYDEBUG > 0
{ int   ierr ;
fprintf(stdout, "\n vmetric") ;
IV_writeForHumanEye(vmetricIV, stdout) ;
fprintf(stdout, "\n dmetric") ;
IV_writeForHumanEye(dmetricIV, stdout) ;
}
#endif
IV_free(vmetricIV) ;
/*
   --------------------------------------------------
   fill the IV object with the ids in the multisector
   --------------------------------------------------
*/
compidsIV = IV_new() ;
IV_init(compidsIV, nvtx, NULL) ;
compids = IV_entries(compidsIV) ;
for ( v = 0 ; v < nvtx ; v++ ) {
   front = vtxToFront[v] ;
   if ( dmetric[front] <= depth ) {
      compids[v] = 0 ;
   } else {
      compids[v] = 1 ;
   }
}
IV_free(dmetricIV) ;

return(compidsIV) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   construct a multisector based on vertices found in a subtree.

   created -- 96jan04, cca
   ----------------------------------------------------------------
*/
IV *
ETree_msByNvtxCutoff (
   ETree    *etree,
   double   cutoff
) {
int      front, nfront, nvtx, v ;
int      *compids, *tmetric, *vtxToFront ;
IV       *compidsIV, *tmetricIV, *vmetricIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL 
   || (nfront = etree->nfront) <= 0
   || (nvtx = etree->nvtx) <= 0 ) {
   fprintf(stderr, "\n fatal error in ETree_msByCutoff(%p,%f)"
           "\n bad input\n", etree, cutoff) ;
   exit(-1) ;
}
vtxToFront = IV_entries(etree->vtxToFrontIV) ;
/*
   ----------------------
   get the subtree metric
   ----------------------
*/
vmetricIV = ETree_nvtxMetric(etree) ;
tmetricIV = Tree_setSubtreeImetric(etree->tree, vmetricIV) ;
#if MYDEBUG > 0
fprintf(stdout, "\n vmetric") ;
IV_writeForHumanEye(stdout, n, vmetricIV) ;
fprintf(stdout, "\n tmetric") ;
IV_writeForHumanEye(stdout, n, tmetricIV) ;
fflush(stdout) ;
#endif
IV_free(vmetricIV) ;
cutoff = cutoff * IV_max(tmetricIV) ;
/*
   --------------------------------------------------
   fill the IV object with the ids in the multisector
   --------------------------------------------------
*/
compidsIV = IV_new() ;
IV_init(compidsIV, nvtx, NULL) ;
compids = IV_entries(compidsIV) ;
tmetric = IV_entries(tmetricIV) ;
for ( v = 0 ; v < nvtx ; v++ ) {
   front = vtxToFront[v] ;
   if ( tmetric[front] >= cutoff ) {
      compids[v] = 0 ;
   } else {
      compids[v] = 1 ;
   }
}
IV_free(tmetricIV) ;

return(compidsIV) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   construct a multisector based on the number 
   of factor entries found in a subtree.

   flag = 1 --> LDL^T
   flag = 2 --> LU

   created -- 96jan04, cca
   -------------------------------------------
*/
IV *
ETree_msByNentCutoff (
   ETree    *etree,
   double   cutoff,
   int      flag
) {
int      front, nfront, nvtx, v ;
int      *compids, *tmetric, *vtxToFront ;
IV       *compidsIV, *tmetricIV, *vmetricIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL 
   || (nfront = etree->nfront) <= 0
   || (nvtx = etree->nvtx) <= 0 
   || flag < 1 || flag > 2 ) {
   fprintf(stderr, "\n fatal error in ETree_msByCutoff(%p,%f,%d)"
           "\n bad input\n", etree, cutoff, flag) ;
   exit(-1) ;
}
vtxToFront = IV_entries(etree->vtxToFrontIV) ;
/*
   ----------------------
   get the subtree metric
   ----------------------
*/
vmetricIV = ETree_nentMetric(etree, flag) ;
tmetricIV = Tree_setSubtreeImetric(etree->tree, vmetricIV) ;
#if MYDEBUG > 0
fprintf(stdout, "\n vmetric") ;
IV_writeForHumanEye(stdout, n, vmetricIV) ;
fprintf(stdout, "\n tmetric") ;
IV_writeForHumanEye(stdout, n, tmetricIV) ;
fflush(stdout) ;
#endif
IV_free(vmetricIV) ;
cutoff = cutoff * IV_max(tmetricIV) ;
/*
   --------------------------------------------------
   fill the IV object with the ids in the multisector
   --------------------------------------------------
*/
compidsIV = IV_new() ;
IV_init(compidsIV, nvtx, NULL) ;
compids = IV_entries(compidsIV) ;
tmetric = IV_entries(tmetricIV) ;
for ( v = 0 ; v < nvtx ; v++ ) {
   front = vtxToFront[v] ;
   if ( tmetric[front] >= cutoff ) {
      compids[v] = 0 ;
   } else {
      compids[v] = 1 ;
   }
}
IV_free(tmetricIV) ;

return(compidsIV) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------
   construct a multisector based on the number 
   of factor operations found in a subtree.

   flag = 1 --> LDL^T
   flag = 2 --> LU

   created -- 96jan04, cca
   -------------------------------------------
*/
IV *
ETree_msByNopsCutoff (
   ETree    *etree,
   double   cutoff,
   int      flag
) {
double   *tmetric ;
DV       *tmetricDV, *vmetricDV ;
int      front, nfront, nvtx, v ;
int      *compids, *vtxToFront ;
IV       *compidsIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL 
   || (nfront = etree->nfront) <= 0
   || (nvtx = etree->nvtx) <= 0 
   || flag < 1 || flag > 2 ) {
   fprintf(stderr, "\n fatal error in ETree_msByCutoff(%p,%f,%d)"
           "\n bad input\n", etree, cutoff, flag) ;
   exit(-1) ;
}
vtxToFront = IV_entries(etree->vtxToFrontIV) ;
/*
   ----------------------
   get the subtree metric
   ----------------------
*/
vmetricDV = ETree_nopsMetric(etree, flag) ;
tmetricDV = Tree_setSubtreeDmetric(etree->tree, vmetricDV) ;
#if MYDEBUG > 0
fprintf(stdout, "\n vmetric") ;
DV_writeForHumanEye(stdout, n, vmetricDV) ;
fprintf(stdout, "\n tmetric") ;
DV_writeForHumanEye(stdout, n, tmetricDV) ;
fflush(stdout) ;
#endif
DV_free(vmetricDV) ;
cutoff = cutoff * DV_max(tmetricDV) ;
/*
   --------------------------------------------------
   fill the IV object with the ids in the multisector
   --------------------------------------------------
*/
compidsIV = IV_new() ;
IV_init(compidsIV, nvtx, NULL) ;
compids = IV_entries(compidsIV) ;
tmetric = DV_entries(tmetricDV) ;
for ( v = 0 ; v < nvtx ; v++ ) {
   front = vtxToFront[v] ;
   if ( tmetric[front] >= cutoff ) {
      compids[v] = 0 ;
   } else {
      compids[v] = 1 ;
   }
}
DV_free(tmetricDV) ;

return(compidsIV) ; }

/*--------------------------------------------------------------------*/
