/*  metrics.c  */

#include "../ETree.h"

/*--------------------------------------------------------------------*/
/*
   ------------------------------------
   return an IV object with the weights 
   of the vertices in each front.

   created -- 96jun23, cca
   ------------------------------------
*/
IV *
ETree_nvtxMetric (
   ETree   *etree
) {
IV   *metricIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL || etree->nfront <= 0 || etree->nvtx <= 0 ) {
   fprintf(stderr, "\n fatal error in ETree_nvtxMetric(%p)"
           "\n bad input\n", etree) ;
   exit(-1) ;
}
metricIV = IV_new() ;
IV_init(metricIV, etree->nfront, NULL) ;
IVcopy(etree->nfront, IV_entries(metricIV), 
                      IV_entries(etree->nodwghtsIV)) ;

return(metricIV) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   return an IV object with the number 
   of factor entries in each front.

   flag = 1 --> LDL^T
   flag = 2 --> LU

   created -- 96jun23, cca
   -----------------------------------
*/
IV *
ETree_nentMetric (
   ETree   *etree,
   int     flag
) {
int    front, nfront, nb, nv ;
int    *bndwghts, *metric, *nodwghts ;
IV     *metricIV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL 
   || (nfront = etree->nfront) <= 0 || etree->nvtx <= 0 ) {
   fprintf(stderr, "\n fatal error in ETree_nentMetric(%p)"
           "\n bad input\n", etree) ;
   exit(-1) ;
}
metricIV = IV_new() ;
IV_init(metricIV, nfront, NULL) ;
metric   = IV_entries(metricIV) ;
nodwghts = IV_entries(etree->nodwghtsIV) ;
bndwghts = IV_entries(etree->bndwghtsIV) ;
if ( flag == 1 ) {
   for ( front = 0 ; front < nfront ; front++ ) {
      nv = nodwghts[front] ;
      nb = bndwghts[front] ;
      metric[front] = (nv*(nv+1))/2 + nv*nb ;
   }
} else if ( flag == 2 ) {
   for ( front = 0 ; front < nfront ; front++ ) {
      nv = nodwghts[front] ;
      nb = bndwghts[front] ;
      metric[front] = nv*nv + 2*nv*nb ;
   }
}

return(metricIV) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   return a DV object with the number 
   of factor operations in each front.

   flag = 1 --> LDL^T
   flag = 2 --> LU

   created -- 96jun23, cca
   -----------------------------------
*/
DV *
ETree_nopsMetric (
   ETree   *etree,
   int     flag
) {
double   nb, nv ;
double   *metric ;
int      front, nfront ;
int      *bndwghts, *nodwghts ;
DV       *metricDV ;
/*
   ---------------
   check the input
   ---------------
*/
if (  etree == NULL 
   || (nfront = etree->nfront) <= 0 || etree->nvtx <= 0 ) {
   fprintf(stderr, "\n fatal error in ETree_nopsMetric(%p)"
           "\n bad input\n", etree) ;
   exit(-1) ;
}
metricDV = DV_new() ;
DV_init(metricDV, nfront, NULL) ;
metric   = DV_entries(metricDV) ;
nodwghts = IV_entries(etree->nodwghtsIV) ;
bndwghts = IV_entries(etree->bndwghtsIV) ;
if ( flag == 1 ) {
   for ( front = 0 ; front < nfront ; front++ ) {
      nv = nodwghts[front] ;
      nb = bndwghts[front] ;
      metric[front] = nv*nb*(nv + nb + 1) + (nv*(nv+1)*(2*nv+1))/6 ;
   }
} else if ( flag == 2 ) {
   for ( front = 0 ; front < nfront ; front++ ) {
      nv = nodwghts[front] ;
      nb = bndwghts[front] ;
      metric[front] = ((nv-1)*nv)/2 + ((nv-1)*nv*(2*nv-1))/6
                    + nv*nb + 2*nv*nb*nb ;
   }
}

return(metricDV) ; }

/*--------------------------------------------------------------------*/
