/*  testMS.c  */

#include "../ETree.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -----------------------
   generate multisectors

   created -- 96oct31, cca
   -----------------------
*/
{
char     *inETreeFileName, *outIVfileName ;
double   cutoff, t1, t2 ;
int      flag, depth, msglvl, rc ;
IV       *msIV ;
ETree    *etree ;
FILE     *msgFile ;

if ( argc != 7 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile inETreeFile outIVfile flag cutoff"
"\n    msglvl      -- message level"
"\n    msgFile     -- message file"
"\n    inETreeFile -- input file, must be *.etreef or *.etreeb"
"\n    outIVfile   -- output file, must be *.ivf or *.ivb"
"\n    flag        -- type of multisector"
"\n       flag = 1 --> multisector via depth of front"
"\n       flag = 2 --> multisector via # of vertices in subtree"
"\n       flag = 3 --> multisector via # of entries in subtree"
"\n       flag = 4 --> multisector via # of operations in subtree"
"\n    cutoff      -- cutoff point for multisector"
"\n", argv[0]) ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
inETreeFileName = argv[3] ;
outIVfileName   = argv[4] ;
flag            = atoi(argv[5]) ;
if ( flag == 1 ) {
   depth = atoi(argv[6]) ;
   fprintf(msgFile, 
           "\n %s "
           "\n msglvl      -- %d" 
           "\n msgFile     -- %s" 
           "\n inETreeFile -- %s" 
           "\n outIVfile   -- %s" 
           "\n flag        -- %d" 
           "\n depth       -- %d" 
           "\n",
           argv[0], msglvl, argv[2], inETreeFileName, outIVfileName,
           flag, depth) ;
   fflush(msgFile) ;
} else if ( 2 <= flag && flag <= 4 ) {
   cutoff = atof(argv[6]) ;
   fprintf(msgFile, 
           "\n %s "
           "\n msglvl      -- %d" 
           "\n msgFile     -- %s" 
           "\n inETreeFile -- %s" 
           "\n outIVfile   -- %s" 
           "\n flag        -- %d" 
           "\n cutoff      -- %f" 
           "\n",
           argv[0], msglvl, argv[2], inETreeFileName, outIVfileName,
           flag, cutoff) ;
   fflush(msgFile) ;
}
/*
   ------------------------
   read in the ETree object
   ------------------------
*/
if ( strcmp(inETreeFileName, "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
etree = ETree_new() ;
MARKTIME(t1) ;
rc = ETree_readFromFile(etree, inETreeFileName) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU %9.5f : read in etree from file %s",
        t2 - t1, inETreeFileName) ;
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from ETree_readFromFile(%p,%s)",
           rc, etree, inETreeFileName) ;
   exit(-1) ;
}
fprintf(msgFile, "\n\n after reading ETree object from file %s",
        inETreeFileName) ;
if ( msglvl > 2 ) {
   ETree_writeForHumanEye(etree, msgFile) ;
} else {
   ETree_writeStats(etree, msgFile) ;
}
fflush(msgFile) ;
/*
   --------------------
   make the multisector
   --------------------
*/
switch ( flag ) {
case  1 :
   msIV = ETree_msByDepth(etree, depth) ;
   break ;
case  2 :
   msIV = ETree_msByNvtxCutoff(etree, cutoff) ;
   break ;
case  3 :
   msIV = ETree_msByNentCutoff(etree, cutoff, 1) ;
   break ;
case  4 :
   msIV = ETree_msByNopsCutoff(etree, cutoff, 1) ;
   break ;
}
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n msIV") ;
   IV_writeForHumanEye(msIV, msgFile) ;
}
/*
   -----------------------
   write out the IV object
   -----------------------
*/
if ( strcmp(outIVfileName, "none") != 0 ) {
   MARKTIME(t1) ;
   rc = IV_writeToFile(msIV, outIVfileName) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %9.5f : write msIV to file %s",
           t2 - t1, outIVfileName) ;
}
if ( rc != 1 ) {
   fprintf(msgFile, "\n return value %d from IV_writeToFile(%p,%s)",
           rc, msIV, outIVfileName) ;
}
/*
   ----------------
   free the objects
   ----------------
*/
ETree_free(etree) ;
IV_free(msIV) ;

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
