/*  testDense.c  */

#include "../ETree.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ------------------------------------------
   create an ETree object for a dense matrix.

   created -- 96aug19, cca
   ------------------------------------------
*/
{
char     *outETreeFileName ;
double   t1, t2 ;
int      msglvl, n, option, param, rc ;
ETree    *etree ;
FILE     *msgFile ;

if ( argc != 7 ) {
   fprintf(stdout, 
      "\n\n usage : %s msglvl msgFile n option param outFile"
      "\n    msglvl   -- message level"
      "\n    msgFile  -- message file"
      "\n    n        -- matrix size "
      "\n    option   -- mapping option"
      "\n       1 --> have all fronts (save the last) "
      "\n             contain the same number of vertices"
      "\n       2 --> have all fronts have roughly equal "
      "\n             numbers of entries"
      "\n    param    -- size parameter"
      "\n       option = 1 --> param = # vertices in each front"
      "\n       option = 2 --> param = # entries in each front"
      "\n    outFile  -- output file, must be *.etreef or *.etreeb"
      "\n", argv[0]) ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
n      = atoi(argv[3]) ;
option = atoi(argv[4]) ;
param  = atoi(argv[5]) ;
outETreeFileName = argv[6] ;
fprintf(msgFile, 
        "\n %s "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n n        -- %d" 
        "\n option   -- %d" 
        "\n param    -- %d" 
        "\n outFile  -- %s" 
        "\n",
        argv[0], msglvl, argv[2], n, option, param, outETreeFileName) ;
fflush(msgFile) ;
/*
   -----------------------
   create the ETree object
   -----------------------
*/
etree = ETree_new() ;
ETree_initFromDenseMatrix(etree, n, option, param) ;
if ( msglvl > 2 ) {
   ETree_writeForHumanEye(etree, msgFile) ;
} else {
   ETree_writeStats(etree, msgFile) ;
}
fflush(msgFile) ;
if ( strcmp(outETreeFileName, "none") != 0 ) {
/*
   --------------------------
   write out the ETree object
   --------------------------
*/
   if ( strcmp(outETreeFileName, "none") != 0 ) {
      MARKTIME(t1) ;
      rc = ETree_writeToFile(etree, outETreeFileName) ;
      MARKTIME(t2) ;
      fprintf(msgFile, "\n CPU %9.5f : write etree to file %s",
              t2 - t1, outETreeFileName) ;
   }
   if ( rc != 1 ) {
      fprintf(msgFile, 
              "\n return value %d from ETree_writeToFile(%p,%s)",
              rc, etree, outETreeFileName) ;
   }
}
/*
   ---------------------
   free the ETree object
   ---------------------
*/
ETree_free(etree) ;

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
