/*  util.c  */

#include "../DVL.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------
   return the number of bytes taken by the object

   created -- 96apr28, cca
   ----------------------------------------------
*/
int
DVL_sizeOf ( 
   DVL   *dvl 
) {
int   nbytes ;
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_sizeOf(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
nbytes = sizeof(struct _DVL) ;
if ( dvl->nlist > 0 ) {
   nbytes += dvl->nlist * (sizeof(int) + sizeof(int *)) ;
   if ( dvl->type == DVL_SOLO ) {
         nbytes += IVsum(dvl->nlist, dvl->sizes) * sizeof(double) ;
   } else {
      Dchunk   *chunk ;
      for ( chunk = dvl->chunk ; 
            chunk != NULL ; 
            chunk = chunk->next ) {
         nbytes += sizeof(Dchunk) + chunk->size * sizeof(double) ;
      }
   }
}
return(nbytes) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------
   return the maximum list size 

   created -- 96apr28, cca
   ----------------------------
*/
int
DVL_maxListSize (
   DVL   *dvl
) {
int      ilist, maxsize, nlist, size ;
double   *vec ;
/*
   -------------------
   check for bad input
   -------------------
*/
if ( dvl == NULL || (nlist = dvl->nlist) <= 0 ) {
   fprintf(stderr, "\n fatal error in DVL_maxListSize(%p)"
           "\n bad input", dvl) ;
   exit(-1) ;
}
for ( ilist = 0, maxsize = 0 ; ilist < nlist ; ilist++ ) {
   DVL_listAndSize(dvl, ilist, &size, &vec) ;
   if ( maxsize < size ) {
      maxsize = size ;
   }
}
return(maxsize) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   DVL object dvl1 absorbs the lists and data from DVL object dvl2.
   the lists in dvl2 are mapped into lists in dvl1 using the mapIV
   IV object.

   created -- 96dec06, cca
   ----------------------------------------------------------------
*/
void
DVL_absorbDVL (
   DVL   *dvl1,
   DVL   *dvl2,
   IV    *mapIV
) {
Dchunk   *chunk ;
double   *vec ;
int      ilist, jlist, nlist2, size ;
int      *map ;
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl1 == NULL || dvl2 == NULL || mapIV == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_absorbDVL(%p,%p,%p)"
           "\n bad input\n", dvl1, dvl2, mapIV) ;
   exit(-1) ;
}
if ( (map = IV_entries(mapIV)) == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_absorbDVL(%p,%p,%p)"
           "\n IV_entries(mapIV) is NULL\n", dvl1, dvl2, mapIV) ;
   exit(-1) ;
}
/*
   --------------------------------------------
   check that the sizes of dvl2 and mapIV agree
   --------------------------------------------
*/
if ( IV_size(mapIV) != (nlist2 = dvl2->nlist) ) {
   fprintf(stderr, "\n fatal error in DVL_absorbDVL(%p,%p,%p)"
           "\n dvl2->nlist = %d, IV_size(mapIV) = %d\n", 
           dvl1, dvl2, mapIV, nlist2, IV_size(mapIV)) ;
   exit(-1) ;
}
/*
   -------------------------------
   for each list in dvl2
      get size and pointer
      get mapped list in dvl1
      set size and pointer in dvl1
   -------------------------------
*/
for ( ilist = 0 ; ilist < nlist2 ; ilist++ ) {
   DVL_listAndSize(dvl2, ilist, &size, &vec) ;
   if ( (jlist = map[ilist]) >= 0 ) {
      DVL_setPointerToList(dvl1, jlist, size, vec) ;
   }
}
if ( (chunk = dvl2->chunk) != NULL ) {
   Dchunk   *prev ;
/*
   -------------------------------------------
   move the chunks of memory from dvl2 to dvl1
   -------------------------------------------
*/
   while ( chunk != NULL ) {
      prev = chunk ;
      chunk = chunk->next ;
   }
   prev->next = dvl1->chunk ;
   dvl1->chunk = dvl2->chunk ;
   dvl2->chunk = NULL ;
}
return ; }

/*--------------------------------------------------------------------*/
