/*  instance.c  */

#include "../DVL.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------
   return the storage type of the object

   created -- 96dec06, cca
   -------------------------------------
*/
int
DVL_type (
   DVL   *dvl
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_type(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
return(dvl->type) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   return the maximum number of lists

   created -- 96dec06, cca
   ----------------------------------
*/
int
DVL_maxnlist (
   DVL   *dvl
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_maxnlist(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
return(dvl->maxnlist) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------
   return the number of lists

   created -- 96dec06, cca
   --------------------------
*/
int
DVL_nlist (
   DVL   *dvl
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_nlist(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
return(dvl->nlist) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   return the total size of the lists

   created -- 96dec06, cca
   ----------------------------------
*/
int
DVL_tsize (
   DVL   *dvl
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_tsize(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
return(dvl->tsize) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------
   return the storage increment

   created -- 96dec06, cca
   ----------------------------
*/
int
DVL_incr (
   DVL   *dvl
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_incr(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
return(dvl->incr) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------
   set the storage increment

   created -- 96dec06, cca
   -------------------------
*/
void
DVL_setincr (
   DVL   *dvl,
   int   incr
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL || incr < 0 ) {
   fprintf(stderr, "\n fatal error in DVL_setincr(%p,%d)"
           "\n bad input\n", dvl, incr) ;
   exit(-1) ;
}
dvl->incr = incr ;

return ; }

/*--------------------------------------------------------------------*/
