/*  basics.c  */

#include "../DVL.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 96apr28, cca
   -----------------------
*/
DVL *
DVL_new ( 
   void 
) {
DVL   *dvl ;

ALLOCATE(dvl, struct _DVL, 1) ;
DVL_setDefaultFields(dvl) ;

return(dvl) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 96apr28, cca
   -----------------------
*/
void
DVL_setDefaultFields (
   DVL   *dvl
) {
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_setDefaultFields(%p)"
           "\n bad input", dvl) ;
   exit(-1) ;
}
dvl->type     = DVL_NOTYPE ;
dvl->maxnlist = 0          ;
dvl->nlist    = 0          ;
dvl->tsize    = 0          ;
dvl->sizes    = NULL       ;
dvl->p_vec    = NULL       ;
dvl->incr     = DVL_INCR   ;
dvl->chunk   = NULL       ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 96apr28, cca
   --------------------------------------------------
*/
void
DVL_clearData ( 
   DVL   *dvl 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_clearData(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
/*
   ----------------------------------------------------
   switch over the storage type to free list entries.
   action is taken when type is DVL_SOLO or DVL_CHUNKED
   ----------------------------------------------------
*/
switch ( dvl->type ) {
case DVL_SOLO : {
   int   ilist ;
   for ( ilist = 0 ; ilist < dvl->nlist ; ilist++ ) {
      if ( dvl->p_vec[ilist] != NULL ) {
         DVfree(dvl->p_vec[ilist]) ;
         dvl->p_vec[ilist] = NULL ;
         dvl->tsize -= dvl->sizes[ilist] ;
      }
   }
   } break ;
case DVL_CHUNKED : {
   Dchunk   *chunk ;
   while ( (chunk = dvl->chunk) != NULL ) {
      dvl->chunk = chunk->next ;
      if ( chunk->base != NULL ) {
         DVfree(chunk->base) ;
         chunk->base = NULL ;
      }
      FREE(chunk) ;
   }
   } break ;
case DVL_NOTYPE  :
case DVL_UNKNOWN :
   break ;
default :
   fprintf(stderr, "\n fatal error in DVL_clearData(%p)"
           "\n invalid type = %d\n", dvl, dvl->type) ;
   exit(-1) ;
}
/*
   -----------------------------------------------
   free storage for the sizes[] and p_vec[] arrays
   -----------------------------------------------
*/
if ( dvl->sizes != NULL ) {
   IVfree(dvl->sizes) ;
   dvl->sizes = NULL ;
}
if ( dvl->p_vec != NULL ) {
   PDVfree(dvl->p_vec) ;
   dvl->p_vec = NULL ;
}
dvl->maxnlist = dvl->nlist = 0 ;
/*
   ----------------------
   set the default fields
   ----------------------
*/
DVL_setDefaultFields(dvl) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 96apr28, cca
   ------------------------------------------
*/
DVL *
DVL_free ( 
   DVL   *dvl 
) {
if ( dvl == NULL ) {
   fprintf(stderr, "\n fatal error in DVL_free(%p)"
           "\n bad input\n", dvl) ;
   exit(-1) ;
}
DVL_clearData(dvl) ;
FREE(dvl) ;

return(NULL) ; }

/*--------------------------------------------------------------------*/
