/*  init.c  */

#include "../DStairMtx.h"

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------
   initialize the DStairMtx object

   stairmtx -- pointer to the DStairMtx object
   J        -- current front ID
   nrow     -- number of rows for the DA2 matrix
   ncol     -- number of cols for the DA2 matrix
   nJ       -- number of rows for the interior node

   created -- 97apr02, dkw
   ------------------------------------------------
*/
void
DStairMtx_init (
   DStairMtx   *stairfront,
   int         J,
   int         nrow,
   int         ncol,
   int         nJ
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( stairfront == NULL || nrow <= 0 || ncol <= 0 || nJ < 0 ) {
   fprintf(stderr, 
           "\n fatal error in DStairMtx_init(%p,%d,%d,%d,%d)"
           "\n bad input\n", stairfront, J, nrow, ncol, nJ) ;
   exit(-1) ;
}
/*
   --------------
   clear any data 
   --------------
*/
DStairMtx_clearData(stairfront) ;

/*
   --------------------
   set the input fields
   --------------------
*/
stairfront->J    = J ;
stairfront->nrow = nrow ;
stairfront->ncol = ncol ;
stairfront->nJ   = nJ   ;

if ( ncol < nrow ) {
   stairfront->nupdrow = ncol - nJ ;  /* overdetermine case */
} else {
   stairfront->nupdrow = nrow - nJ ;  /* underdetermine case */
}

/*
   ------------------------------------------------
   initialize the staircase DA2 object in row major
   ------------------------------------------------
*/
   DA2_init(&stairfront->stairmtx, nrow, ncol, ncol, 1, NULL) ;

/*
   ---------------------------------------
   initialize the column lastrow IV object
   ---------------------------------------
*/
IV_init(&stairfront->lastrowIV, ncol, NULL) ;
IV_fill(&stairfront->lastrowIV, 0) ;

return ; }

/*--------------------------------------------------------------------*/
