/*  formStaircase.c  */
 
#include "../DStairMtx.h"
 
#define MYDEBUG 0
 
/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   change the front matrix into staircase form
   and construct the lastrowIV vector
   created -- 97apr30, dkw
   --------------------------------------------
*/
void
DStairMtx_formStaircase (
   DStairMtx *stairfront,
   int       msglvl,
   FILE      *msgFile
) {
DA2      *stairmtx ;
int      irowJ, jcolJ, ncolJ, nrowJ, rc ;
int      *firstnonzero, *lastrowindex ;

/*
   ---------------
   check the input
   ---------------
*/
if (  stairfront == NULL ) {
   fprintf(stderr,
       "\n fatal error in DStairMtx_formStaircase(%p,%d,%p)"
       "\n bad input\n", stairfront, msglvl, msgFile) ;
   exit(-1) ;
}
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n ### inside DStairMtx_formStaircase ") ;
   fflush(msgFile) ;
}

/*
   ------------------------------------
   sort matrix rows into staircase form
   and calculate lastrowindex
   ------------------------------------
*/
nrowJ = stairfront->nrow ;
ncolJ = stairfront->ncol ;
stairmtx     = &stairfront->stairmtx ;
if ( msglvl > 4 ) {
   fprintf(msgFile, "\n staircase matrix before sorting") ;
   DA2_writeForHumanEye(stairmtx, msgFile) ;
   fflush(msgFile) ;
}
lastrowindex = IV_entries(&stairfront->lastrowIV) ;
firstnonzero = IVinit(nrowJ, -1) ;
for ( irowJ = 0 ; irowJ < nrowJ ; irowJ++ ) {
   for ( jcolJ = 0 ; jcolJ < ncolJ ; jcolJ++ ) {
       if ( DA2_entry(stairmtx, irowJ, jcolJ) != 0.0 ) {
          break ;
       }
   }
   firstnonzero[irowJ] = jcolJ ;
   if ( jcolJ < ncolJ ) lastrowindex[jcolJ]++ ;
}

rc = DA2_sortRowsUp( stairmtx, nrowJ, firstnonzero ) ;

lastrowindex[0]-- ;
for ( jcolJ = 1 ; jcolJ < ncolJ ; jcolJ++ ) {
      lastrowindex[jcolJ] += lastrowindex[jcolJ-1] ;
}

if ( msglvl > 4 ) {
   fprintf(msgFile, "\n staircase matrix after sorting") ;
   DA2_writeForHumanEye(stairmtx, msgFile) ;
   fflush(msgFile) ;
   fprintf(msgFile, "\n lastrowindex for ncol ") ;
   rc = IV_writeForHumanEye(&stairfront->lastrowIV, msgFile) ;
   fflush(msgFile) ;
}
IVfree(firstnonzero) ;
return ; }
