/*  basics.c  */

#include "../DStairMtx.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97mar31, dkw
   -----------------------
*/
DStairMtx *
DStairMtx_new ( 
   void 
) {
DStairMtx   *mtx ;
 
ALLOCATE(mtx, struct _DStairMtx, 1) ;
DStairMtx_setDefaultFields(mtx) ;
 
return(mtx) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97mar31, dkw
   -----------------------
*/
void
DStairMtx_setDefaultFields (
   DStairMtx   *mtx
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DStairMtx_setDefaultFields(%p)"
           "\n bad input", mtx) ;
   exit(-1) ;
}
DA2_setDefaultFields(&mtx->stairmtx) ;
mtx->J            =   0  ;
mtx->nrow         =   0  ;
mtx->ncol         =   0  ;
mtx->nJ           =   0  ;
mtx->nupdrow      =   0  ;
IV_setDefaultFields(&mtx->lastrowIV)  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97mar31, dkw
   --------------------------------------------------
*/
void
DStairMtx_clearData ( 
   DStairMtx   *mtx 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DStairMtx_clearData(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
DA2_clearData(&mtx->stairmtx) ;
IV_clearData(&mtx->lastrowIV)  ;

/*
   ----------------------
   set the default fields
   ----------------------
*/
DStairMtx_setDefaultFields(mtx) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97mar31, dkw
   ------------------------------------------
*/
DStairMtx *
DStairMtx_free ( 
   DStairMtx   *mtx 
) {
if ( mtx == NULL ) {
   fprintf(stderr, "\n fatal error in DStairMtx_free(%p)"
           "\n bad input\n", mtx) ;
   exit(-1) ;
}
DStairMtx_clearData(mtx) ;
FREE(mtx) ;

return(NULL) ; }

/*--------------------------------------------------------------------*/
