/*  IO.c  */

#include "../DStairMtx.h"

/*--------------------------------------------------------------------*/
/*
   ------------------------------
   print out the DStairMtx object

   created -- 97may06, dkw
   ------------------------------
*/
void
DStairMtx_writeForHumanEye (
   DStairMtx  *stairmtx,
   FILE       *fp
) {

if ( stairmtx == NULL || fp == NULL ) {
   fprintf(stderr, "\n fatal error in DStairMtx_writeForHumanEye(%p,%p)"
           "\n bad input\n", stairmtx, fp) ;
   exit(-1) ;
}
fprintf(fp, 
"\n DStairMtx(%p) : J = %d, nrow = %d, ncol = %d, nJ = %d, nupdrow = %d", 
stairmtx, stairmtx->J, stairmtx->nrow, stairmtx->ncol, stairmtx->nJ,
stairmtx->nupdrow) ;

fprintf(fp, "\n stairmtx DA2") ;
DA2_writeForHumanEye(&stairmtx->stairmtx, fp) ;
fflush(fp) ;

fprintf(fp, "\n lastrowIV:") ;
IV_writeForHumanEye(&stairmtx->lastrowIV, fp) ;
fflush(fp) ;

return ; }

/*--------------------------------------------------------------------*/
