/*  test_QR.c  */

#include "../DStairMtx.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   --------------------------------------
   test the QR routine DStairMtx_QRfactor

   created -- 97mar29, dkw
   --------------------------------------
*/
{
DA2      *a ;
double   t1, t2 ;
double   facops ;
FILE     *msgFile ;
int      i, msglvl, ncolA, nrowA, seed ;
int      *lastrowindex ;

if ( argc != 6 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile nrowA ncolA seed "
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    nrowA   -- # of rows in A"
"\n    ncolA   -- # of columns in A"
"\n    seed    -- random number seed"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nrowA = atoi(argv[3]) ;
ncolA = atoi(argv[4]) ;
if (  nrowA <= 0 || ncolA <= 0 ) {
   fprintf(stderr, "\n invalid matrix dimensions"
           "\n nrowA = %d, ncolA = %d", nrowA, ncolA) ;
   exit(-1) ;
}
seed = atoi(argv[5]) ;
fprintf(msgFile, "\n nrowA = %d, ncolA = %d", nrowA, ncolA) ;
fflush(msgFile) ;
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
a = DA2_new() ;
DA2_init(a, nrowA, ncolA, ncolA, 1, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix object",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(a, 0, 1, seed) ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(a, msgFile) ;
}
lastrowindex = (int *) malloc (ncolA*sizeof(int));
for ( i = 0; i < ncolA; i++){
   lastrowindex[i] = nrowA - 1 ;
}
/*
   ----------------------------
   compute the QR factorization
   ----------------------------
*/
MARKTIME(t1) ;
DStairMtx_QRfactor(a, lastrowindex, &facops) ;
MARKTIME(t2) ;
fprintf(msgFile, 
"\n CPU : %.3f compute QR factorization", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n A") ;
   DA2_writeForHumanEye(a, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
