/*  test_formStaircase.c  */

#include "../DStairMtx.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ------------------------------
   test the formStaircase routine

   created -- 97jun16, dkw
   ------------------------------
*/
{
DA2       *stairmtx ;
DStairMtx *stairfront ;
double   t1, t2 ;
FILE     *msgFile ;
int      msglvl ;

if ( argc != 3 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "w")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;

stairfront = DStairMtx_new() ;
DStairMtx_init(stairfront, 0, 6, 6, 0) ;
stairmtx = &stairfront->stairmtx ;
DA2_setEntry(stairmtx, 0, 3, 1.0) ;
DA2_setEntry(stairmtx, 1, 0, 1.0) ;
DA2_setEntry(stairmtx, 1, 1, 1.0) ;
DA2_setEntry(stairmtx, 1, 2, 1.0) ;
DA2_setEntry(stairmtx, 2, 1, 1.0) ;
DA2_setEntry(stairmtx, 3, 0, 1.0) ;
DA2_setEntry(stairmtx, 4, 3, 1.4) ;
DA2_setEntry(stairmtx, 4, 4, 1.4) ;
DA2_setEntry(stairmtx, 4, 5, 1.4) ;
DA2_setEntry(stairmtx, 5, 1, 1.5) ;
DA2_setEntry(stairmtx, 5, 2, 1.5) ;
DA2_setEntry(stairmtx, 5, 3, 1.5) ;
DA2_setEntry(stairmtx, 5, 4, 1.5) ;
DA2_setEntry(stairmtx, 5, 5, 1.5) ;

MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix objects",
        t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n staircase matrix ") ;
   DStairMtx_writeForHumanEye(stairfront, msgFile) ;
   fflush(msgFile) ;
}
/*
   ------------------------------
   put matrix into staircase form
   ------------------------------
*/
MARKTIME(t1) ;
DStairMtx_formStaircase(stairfront, msglvl, msgFile) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to form staircase matrix", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n staircase matrix") ;
   DStairMtx_writeForHumanEye(stairfront, msgFile) ;
   fflush(msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
