/*  DStairMtx.h  */

#include "../DA2.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------------
   stairmtx  -- DA2 object that holds the staircase matrix
   J         -- current front ID
   nrow      -- number of rows in the matrix
   ncol      -- number of columns in the matrix
   nJ        -- number of interior rows in the matrix
   nupdrow   -- number of rows in the update matrix
   lastrowIV -- IV object of length ncol that holds the index of the
                last row of the staircase matrix

   created -- 97mar31, dkw
   -------------------------------------------------------------------
*/
typedef
struct _DStairMtx {
   DA2       stairmtx  ;
   int       J         ;
   int       nrow      ;
   int       ncol      ;
   int       nJ        ;
   int       nupdrow   ;
   IV        lastrowIV ;
} DStairMtx ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in basics.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   simplest constructor

   created -- 97mar31, dkw
   -----------------------
*/
DStairMtx *
DStairMtx_new ( 
   void 
) ;
/*
   -----------------------
   set the default fields

   created -- 97mar31, dkw
   -----------------------
*/
void
DStairMtx_setDefaultFields (
   DStairMtx   *mtx
) ;
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97mar31, dkw
   --------------------------------------------------
*/
void
DStairMtx_clearData ( 
   DStairMtx   *mtx 
) ;
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97mar31, dkw
   ------------------------------------------
*/
DStairMtx *
DStairMtx_free ( 
   DStairMtx   *mtx 
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in init.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   initialize the object
 
   created -- 97mar31, dkw
   -----------------------
*/
void
DStairMtx_init (
   DStairMtx   *stairmtx,
   int         J,
   int         nrow,
   int         ncol,
   int         nJ
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in QRfactor.c --------------------------------------
------------------------------------------------------------------------
*/
/*
   --------------------------------------------------------------
   purpose ---
      given a matrix A, convert to an upper triangular or
      upper trapezoidal R using householder transformations.
      The transformations and their coeffecients are not saved.
 
      this code follows closely page 210 from golub and van loan,
      "matrix computations", 3rd edition.
 
      note: presently the matrix must be row major
 
   created -- 97mar29, dkw
   --------------------------------------------------------------
*/
void
DStairMtx_QRfactor (
  DA2    *mtx,
  int    *lastrowindex,
  double *facops
);
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in IO.c --------------------------------------------
------------------------------------------------------------------------
*/
/*
   ----------------------------------------------
   purpose -- to write the object for a human eye

   created -- 97mar31, dkw
   ----------------------------------------------
*/
void
DStairMtx_writeForHumanEye (
   DStairMtx  *mtx,
   FILE       *fp
) ;

/*
   ----------------------------------------------
   purpose -- to change the front matrix into
              staircase form and construct the
              lastrowIV vector
 
   created -- 97mar31, dkw
   ----------------------------------------------
*/
void
DStairMtx_formStaircase (
   DStairMtx *stairfront,
   int       msglvl,
   FILE      *fp
) ;
