/*  util.c  */

#include "../DPencil.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------------------
   sort and compress the pencil's entries

   created -- 97jul18, cca
   --------------------------------------
*/
void
DPencil_sortAndCompress (
   DPencil   *pencil 
) {

if ( pencil->inpmtxA != NULL ) {
   DInpMtx_sortAndCompress(pencil->inpmtxA) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_sortAndCompress(pencil->inpmtxB) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------
   convert the storage to vectors

   created -- 97jul18, cca
   ------------------------------
*/
void
DPencil_convertToVectors (
   DPencil   *pencil 
) {

if ( pencil->inpmtxA != NULL ) {
   DInpMtx_convertToVectors(pencil->inpmtxA) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_convertToVectors(pencil->inpmtxB) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------
   map entries to the lower triangle,
   used after a permutation of a symmetric matrix

   created -- 97jul18, cca
   ----------------------------------------------
*/
void
DPencil_mapToLowerTriangle (
   DPencil   *pencil 
) {

if ( pencil->inpmtxA != NULL ) {
   DInpMtx_mapToLowerTriangle(pencil->inpmtxA) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_mapToLowerTriangle(pencil->inpmtxB) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------
   map entries to the upper triangle,
   used after a permutation of a symmetric matrix

   created -- 97jul18, cca
   ----------------------------------------------
*/
void
DPencil_mapToUpperTriangle (
   DPencil   *pencil 
) {

if ( pencil->inpmtxA != NULL ) {
   DInpMtx_mapToUpperTriangle(pencil->inpmtxA) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_mapToUpperTriangle(pencil->inpmtxB) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- to return the full, symmetric adjacency IVL object
              for the graph of (A + B) + sigma * (A + B)^T
 
   created -- 97nov05, cca
   -------------------------------------------------------------
*/
IVL *
DPencil_fullAdjacency (
   DPencil  *pencil
) {
IVL   *adjIVL ;
/*
   ---------------
   check the input
   ---------------
*/
if ( pencil == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_fullAdjacency(%p)"
           "\n NULL input\n\n", pencil) ;
   exit(-1) ;
}
if ( pencil->sigma == 0.0 ) {
   if ( pencil->inpmtxA == NULL ) {
      fprintf(stderr, "\n fatal error in DPencil_fullAdjacency(%p)"
              "\n pencil is identity \n\n", pencil) ;
      exit(-1) ;
   } else {
      adjIVL = DInpMtx_fullAdjacency(pencil->inpmtxA) ;
   }
} else {
   if ( pencil->inpmtxB == NULL ) {
      adjIVL = DInpMtx_fullAdjacency(pencil->inpmtxA) ;
   } else if ( pencil->inpmtxA == NULL ) {
      adjIVL = DInpMtx_fullAdjacency(pencil->inpmtxB) ;
   } else {
      adjIVL = DInpMtx_fullAdjacency2(pencil->inpmtxA, pencil->inpmtxB);
   }
}
return(adjIVL) ; }

/*--------------------------------------------------------------------*/
