/*  mvm.c  */

#include "../DPencil.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------
   compute y = (A + sigma*B)x

   created -- 97jul18, cca
   --------------------------
*/
void
DPencil_mvm (
   DPencil   *pencil,
   DV        *yDV,
   DV        *xDV
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( pencil == NULL || yDV == NULL || xDV == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_mvm(%p,%p,%p)"
           "\n bad input\n", pencil, yDV, xDV) ;
   exit(-1) ;
}
/*
   ------
   zero Y
   ------
*/
DV_fill(yDV, 0.0) ;
if ( pencil->inpmtxA == NULL ) {
/*
   -----------------
   A is the identity
   -----------------
*/
   DV_copy(yDV, xDV) ;
} else {
/*
   ----------------------------------------
   A is not the identity, multiply x with A
   ----------------------------------------
*/
   DInpMtx_mvm(pencil->inpmtxA, yDV, 1.0, xDV) ;
}
if ( pencil->sigma != 0.0 ) {
   if ( pencil->inpmtxB != NULL ) {
/*
      -----------------------------------------
      B is not the identity, add sigma*B*x to y
      -----------------------------------------
*/
      DInpMtx_mvm(pencil->inpmtxB, yDV, pencil->sigma, xDV) ;
   } else {
/*
      -----------------------------------
      B is the identity, add sigma*x to y
      -----------------------------------
*/
      double   *enty, *entx ;
      int      ii, sizex, sizey ;

      DV_sizeAndEntries(yDV, &sizey, &enty) ;
      DV_sizeAndEntries(xDV, &sizex, &entx) ;
      if ( sizey != sizex ) {
         fprintf(stderr, "\n fatal error in DPencil_mvm(%p,%p,%p)"
                 "\n sizey = %d, sizex = %d,\n", 
                 pencil, yDV, xDV, sizey, sizex) ;
         exit(-1) ;
      }
      for ( ii = 0 ; ii < sizey ; ii++ ) {
         enty[ii] += pencil->sigma * entx[ii] ;
      }
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------
   compute y = (A + sigma*B)x
   where A and B are symmetric

   created -- 97jul18, cca
   ---------------------------
*/
void
DPencil_symmetricMVM (
   DPencil   *pencil,
   DV        *yDV,
   DV        *xDV
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( pencil == NULL || yDV == NULL || xDV == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_symmetricMVM(%p,%p,%p)"
           "\n bad input\n", pencil, yDV, xDV) ;
   exit(-1) ;
}
/*
   ------
   zero Y
   ------
*/
DV_fill(yDV, 0.0) ;
if ( pencil->inpmtxA == NULL ) {
/*
   -----------------
   A is the identity
   -----------------
*/
   DV_copy(yDV, xDV) ;
} else {
/*
   ----------------------------------------
   A is not the identity, multiply x with A
   ----------------------------------------
*/
   DInpMtx_symmetricMVM(pencil->inpmtxA, yDV, 1.0, xDV) ;
}
if ( pencil->sigma != 0.0 ) {
   if ( pencil->inpmtxB != NULL ) {
/*
      -----------------------------------------
      B is not the identity, add sigma*B*x to y
      -----------------------------------------
*/
      DInpMtx_symmetricMVM(pencil->inpmtxB, yDV, pencil->sigma, xDV) ;
   } else {
/*
      -----------------------------------
      B is the identity, add sigma*x to y
      -----------------------------------
*/
      double   *enty, *entx ;
      int      ii, sizex, sizey ;

      DV_sizeAndEntries(yDV, &sizey, &enty) ;
      DV_sizeAndEntries(xDV, &sizex, &entx) ;
      if ( sizey != sizex ) {
         fprintf(stderr, 
                 "\n fatal error in DPencil_symmetricMVM(%p,%p,%p)"
                 "\n sizey = %d, sizex = %d,\n", 
                 pencil, yDV, xDV, sizey, sizex) ;
         exit(-1) ;
      }
      for ( ii = 0 ; ii < sizey ; ii++ ) {
         enty[ii] += pencil->sigma * entx[ii] ;
      }
   }
}
return ; }

/*--------------------------------------------------------------------*/
