/*  init.c  */

#include "../DPencil.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   initialize the object

   created -- 97jul13, cca
   -----------------------
*/
void
DPencil_init (
  DPencil   *pencil,
  DInpMtx   *inpmtxA,
  double    sigma,
  DInpMtx   *inpmtxB
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  pencil == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_init(%p,%p,%f,%p)"
           "\n bad input\n", 
           pencil, inpmtxA, sigma, inpmtxB) ;
   exit(-1) ;
}
/*
   ------------------------
   clear the data structure
   ------------------------
*/
DPencil_clearData(pencil) ;
/*
   --------------
   set the fields
   --------------
*/
pencil->inpmtxA = inpmtxA ;
pencil->sigma   = sigma   ;
pencil->inpmtxB = inpmtxB ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------
   change the coordinate type

   created -- 97jul18, cca
   --------------------------
*/
void
DPencil_changeCoordType (
   DPencil   *pencil,
   int       newType
) {
if ( pencil->inpmtxA != NULL ) {
   DInpMtx_changeCoordType(pencil->inpmtxA, newType) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_changeCoordType(pencil->inpmtxB, newType) ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   change the storage mode

   created -- 97jul18, cca
   -----------------------
*/
void
DPencil_changeStorageMode (
   DPencil   *pencil,
   int       newMode
) {
if ( pencil->inpmtxA != NULL ) {
   DInpMtx_changeStorageMode(pencil->inpmtxA, newMode) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_changeStorageMode(pencil->inpmtxB, newMode) ;
}
return ; }

/*--------------------------------------------------------------------*/
