/*  basics.c  */

#include "../DPencil.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jul13, cca
   -----------------------
*/
DPencil *
DPencil_new ( 
   void 
) {
DPencil   *pencil ;

ALLOCATE(pencil, struct _DPencil, 1) ;
DPencil_setDefaultFields(pencil) ;

return(pencil) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jul13, cca
   -----------------------
*/
void
DPencil_setDefaultFields (
   DPencil   *pencil
) {
if ( pencil == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_setDefaultFields(%p)"
           "\n bad input", pencil) ;
   exit(-1) ;
}
pencil->sigma   =   0  ;
pencil->inpmtxA = NULL ;
pencil->inpmtxB = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jul13, cca
   --------------------------------------------------
*/
void
DPencil_clearData ( 
   DPencil   *pencil 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( pencil == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_clearData(%p)"
           "\n bad input\n", pencil) ;
   exit(-1) ;
}
/*
   -----------------
   free the matrices
   -----------------
*/
if ( pencil->inpmtxA != NULL ) {
   DInpMtx_free(pencil->inpmtxA) ;
}
if ( pencil->inpmtxB != NULL ) {
   DInpMtx_free(pencil->inpmtxB) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DPencil_setDefaultFields(pencil) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jul13, cca
   ------------------------------------------
*/
DPencil *
DPencil_free ( 
   DPencil   *pencil 
) {
if ( pencil == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_free(%p)"
           "\n bad input\n", pencil) ;
   exit(-1) ;
}
DPencil_clearData(pencil) ;
FREE(pencil) ;

return(NULL) ; }

/*--------------------------------------------------------------------*/
