/*  IO.c  */

#include "../DPencil.h"

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------------------------
   purpose -- to read in a DPencil object from a file

   input --

      inpmtxAfileName -- filename for A, must be *.inpmtxb or *.inpmtxf
      inpmtxBfileName -- filename for B, must be *.inpmtxb or *.inpmtxf

   return value -- 1 if success, 0 if failure

   created -- 97jul18, cca
   -------------------------------------------------------------------
*/
int
DPencil_readFromFiles ( 
   DPencil   *pencil, 
   char      *inpmtxAfileName, 
   char      *inpmtxBfileName 
) {
int    rc = 1 ;
/*
   ---------------
   check the input
   ---------------
*/
if (  pencil == NULL || inpmtxAfileName == NULL 
   || inpmtxBfileName == NULL ) {
   fprintf(stderr, "\n error in DPencil_readFromFile(%p,%s,%s)"
           "\n bad input\n", pencil, inpmtxAfileName, inpmtxBfileName) ;
   return(0) ;
}
if ( strcmp(inpmtxAfileName, "none") != 0 ) {
   rc = DInpMtx_readFromFile(pencil->inpmtxA, inpmtxAfileName) ;
   if ( rc != 1 ) {
      return(rc) ;
   } 
}
if ( strcmp(inpmtxBfileName, "none") != 0 ) {
   rc = DInpMtx_readFromFile(pencil->inpmtxB, inpmtxBfileName) ;
   if ( rc != 1 ) {
      return(rc) ;
   } 
}
return(rc) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   purpose -- to write a DPencil object for a human eye

   return value -- 1 if success, 0 otherwise

   created -- 97jul18, cca
   ----------------------------------------------------
*/
int
DPencil_writeForHumanEye ( 
   DPencil   *pencil, 
   FILE      *fp 
) {
int   rc ;

if ( pencil == NULL || fp == NULL ) {
   fprintf(stderr, "\n fatal error in DPencil_writeForHumanEye(%p,%p)"
           "\n bad input\n", pencil, fp) ;
   exit(-1) ;
}
/*
   ------------------------
   write out the statistics
   ------------------------
*/
fprintf(fp, "\n\n DPencil : double precision matrix pencil object :") ;
if ( pencil->inpmtxA != NULL ) {
   fprintf(fp, "\n\n inpmtxA") ;
   DInpMtx_writeForHumanEye(pencil->inpmtxA, fp) ;
}
if ( pencil->inpmtxB != NULL ) {
   fprintf(fp, "\n\n inpmtxB") ;
   DInpMtx_writeForHumanEye(pencil->inpmtxB, fp) ;
}
return(1) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- to write out the statistics for the DPencil object

   return value -- 1 if success, 0 otherwise

   created -- 97jul18, cca
   -------------------------------------------------------------
*/
int
DPencil_writeStats ( 
   DPencil   *pencil, 
   FILE      *fp 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( pencil == NULL || fp == NULL ) {
   fprintf(stderr, "\n error in DPencil_writeStats(%p,%p)"
           "\n bad input\n", pencil, fp) ;
   exit(-1) ;
}
fprintf(fp, "\n DPencil : double precision matrix pencil object :") ;
if ( pencil->inpmtxA != NULL ) {
   fprintf(fp, "\n\n inpmtxA") ;
   DInpMtx_writeStats(pencil->inpmtxA, fp) ;
}
if ( pencil->inpmtxB != NULL ) {
   fprintf(fp, "\n\n inpmtxB") ;
   DInpMtx_writeStats(pencil->inpmtxB, fp) ;
}

return(1) ; }

/*--------------------------------------------------------------------*/
