/*  permute.c  */

#include "../DLinSystem.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------
   permute the linear system
   
   created -- 97jul28, cca
   -------------------------
*/
void
DLinSystem_permute (
   DLinSystem   *linsys,
   IV           *oldToNewIV,
   int          msglvl,
   FILE         *msgFile
) {
DA2      mtx ;
double   t1, t2 ;
int      ii, nrow ;
int      *oldToNew, *rowind ;
/*
   --------------------------
   permute the DPencil object
   --------------------------
*/
if ( linsys->pencil != NULL ) {
   MARKTIME(t1) ;
   DPencil_permute(linsys->pencil, oldToNewIV, oldToNewIV) ;
   if ( linsys->symflag == 0 ) {
      DPencil_mapToUpperTriangle(linsys->pencil) ;
   }
   DPencil_changeCoordType(linsys->pencil, 3) ;
   DPencil_changeStorageMode(linsys->pencil, 2) ;
   MARKTIME(t2) ;
   /*
   DPencil_writeForHumanEye(linsys->pencil, msgFile) ;
   */
   fprintf(msgFile, "\n CPU %8.3f : permute pencil ", t2 - t1) ;
}
/*
   --------------------
   permute the solution
   --------------------
*/
oldToNew = IV_entries(oldToNewIV) ;
if ( linsys->solmtx != NULL ) {
   MARKTIME(t1) ;
   DDenseMtx_rowIndices(linsys->solmtx, &nrow, &rowind) ;
   for ( ii = 0 ; ii < nrow ; ii++ ) {
      rowind[ii] = oldToNew[rowind[ii]] ;
   }
   DA2_setDefaultFields(&mtx) ;
   DDenseMtx_setDA2(linsys->solmtx, &mtx) ;
   DA2_sortRowsUp(&mtx, nrow, rowind) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %8.3f : permute solmtx ", t2 - t1) ;
}
/*
   ---------------------------
   permute the right hand side
   ---------------------------
*/
if ( linsys->rhsmtx != NULL ) {
   MARKTIME(t1) ;
   DDenseMtx_rowIndices(linsys->rhsmtx, &nrow, &rowind) ;
   for ( ii = 0 ; ii < nrow ; ii++ ) {
      rowind[ii] = oldToNew[rowind[ii]] ;
   }
   DA2_setDefaultFields(&mtx) ;
   DDenseMtx_setDA2(linsys->rhsmtx, &mtx) ;
   DA2_sortRowsUp(&mtx, nrow, rowind) ;
   MARKTIME(t2) ;
   fprintf(msgFile, "\n CPU %8.3f : permute rhsmtx ", t2 - t1) ;
}
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n after permutation") ;
   if ( linsys->pencil != NULL ) {
      fprintf(msgFile, "\n\n after permutation") ;
      DPencil_writeForHumanEye(linsys->pencil, msgFile) ;
   }
   if ( linsys->solmtx != NULL ) {
      fprintf(msgFile, "\n\n solution solmtx") ;
      DDenseMtx_writeForHumanEye(linsys->solmtx, msgFile) ;
   }
   if ( linsys->rhsmtx != NULL ) {
      fprintf(msgFile, "\n\n right hand side rhsmtx") ;
      DDenseMtx_writeForHumanEye(linsys->rhsmtx, msgFile) ;
   }
   fflush(msgFile) ;
}
return ; }

/*--------------------------------------------------------------------*/
