/*  init.c  */

#include "../DLinSystem.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   initialize the object

   created -- 97jul28, cca
   -----------------------
*/
void
DLinSystem_init (
  DLinSystem   *linsys,
  int          neqns,
  int          nrhs,
  int          symflag,
  DPencil      *pencil,
  DDenseMtx    *solmtx,
  DDenseMtx    *rhsmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if (  linsys == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DLinSystem_init(%p,%d,%d,%d,%p,%p,%p)"
           "\n bad input\n", 
           linsys, neqns, nrhs, symflag, pencil, solmtx, rhsmtx) ;
   exit(-1) ;
}
/*
   ------------------------
   clear the data structure
   ------------------------
*/
DLinSystem_clearData(linsys) ;
/*
   --------------
   set the fields
   --------------
*/
linsys->neqns   = neqns   ;
linsys->nrhs    = nrhs    ;
linsys->symflag = symflag ;
linsys->pencil  = pencil  ;
linsys->solmtx  = solmtx  ;
linsys->rhsmtx  = rhsmtx  ;

return ; }

/*--------------------------------------------------------------------*/
