/*  basics.c  */

#include "../DLinSystem.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 97jul28, cca
   -----------------------
*/
DLinSystem *
DLinSystem_new ( 
   void 
) {
DLinSystem   *linsys ;

ALLOCATE(linsys, struct _DLinSystem, 1) ;
DLinSystem_setDefaultFields(linsys) ;

return(linsys) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97jul28, cca
   -----------------------
*/
void
DLinSystem_setDefaultFields (
   DLinSystem   *linsys
) {
if ( linsys == NULL ) {
   fprintf(stderr, "\n fatal error in DLinSystem_setDefaultFields(%p)"
           "\n bad input", linsys) ;
   exit(-1) ;
}
linsys->neqns   =   0  ;
linsys->nrhs    =   0  ;
linsys->symflag =   0  ;
linsys->pencil  = NULL ;
linsys->solmtx  = NULL ;
linsys->rhsmtx  = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 97jul28, cca
   --------------------------------------------------
*/
void
DLinSystem_clearData ( 
   DLinSystem   *linsys 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( linsys == NULL ) {
   fprintf(stderr, "\n fatal error in DLinSystem_clearData(%p)"
           "\n bad input\n", linsys) ;
   exit(-1) ;
}
/*
   -----------------
   free the matrices
   -----------------
*/
if ( linsys->pencil != NULL ) {
   DPencil_free(linsys->pencil) ;
}
if ( linsys->solmtx != NULL ) {
   DDenseMtx_free(linsys->solmtx) ;
}
if ( linsys->rhsmtx != NULL ) {
   DDenseMtx_free(linsys->rhsmtx) ;
}
/*
   ----------------------
   set the default fields
   ----------------------
*/
DLinSystem_setDefaultFields(linsys) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 97jul28, cca
   ------------------------------------------
*/
DLinSystem *
DLinSystem_free ( 
   DLinSystem   *linsys 
) {
if ( linsys == NULL ) {
   fprintf(stderr, "\n fatal error in DLinSystem_free(%p)"
           "\n bad input\n", linsys) ;
   exit(-1) ;
}
DLinSystem_clearData(linsys) ;
FREE(linsys) ;

return(NULL) ; }

/*--------------------------------------------------------------------*/
