/*  IO.c  */

#include "../DLinSystem.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------
   purpose -- to write a DLinSystem object for a human eye

   return value -- 1 if success, 0 otherwise

   created -- 97jul29, cca
   -------------------------------------------------------
*/
int
DLinSystem_writeForHumanEye ( 
   DLinSystem   *linsys, 
   FILE         *fp 
) {
if ( linsys == NULL || fp == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DLinSystem_writeForHumanEye(%p,%p)"
           "\n bad input\n", linsys, fp) ;
   exit(-1) ;
}
/*
   ------------------------
   write out the statistics
   ------------------------
*/
fprintf(fp, 
        "\n\n DLinSystem : double precision matrix linsys object :") ;
if ( linsys->pencil != NULL ) {
   fprintf(fp, "\n\n pencil") ;
   DPencil_writeForHumanEye(linsys->pencil, fp) ;
}
if ( linsys->solmtx != NULL ) {
   fprintf(fp, "\n\n solution matrix") ;
   DDenseMtx_writeForHumanEye(linsys->solmtx, fp) ;
}
if ( linsys->rhsmtx != NULL ) {
   fprintf(fp, "\n\n right hand side matrix") ;
   DDenseMtx_writeForHumanEye(linsys->rhsmtx, fp) ;
}
return(1) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------------------
   purpose -- to write out the statistics for the DLinSystem object

   return value -- 1 if success, 0 otherwise

   created -- 97jul29, cca
   ----------------------------------------------------------------
*/
int
DLinSystem_writeStats ( 
   DLinSystem   *linsys, 
   FILE         *fp 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( linsys == NULL || fp == NULL ) {
   fprintf(stderr, "\n error in DLinSystem_writeStats(%p,%p)"
           "\n bad input\n", linsys, fp) ;
   exit(-1) ;
}
fprintf(fp, "\n DLinSystem : double precision linear system object :") ;
fprintf(fp, "\n %d equations, %d right hand sides, symflag = %d",
        linsys->neqns, linsys->nrhs, linsys->symflag) ;

return(1) ; }

/*--------------------------------------------------------------------*/
