/*  util.c  */

#include "../DInpMtx.h"

#define MYDEBUG  0

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   given the data is in raw triples,
   sort and compress the data

   created -- 96jul05, cca
   ---------------------------------
*/
void
DInpMtx_sortAndCompress (
   DInpMtx   *inpmtx
) {
int      ii, jj, length, nent, prev ;
int      *ivec1, *ivec2 ;
double   *dvec ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || inpmtx->storageMode != 1 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_sortAndCompress(%p)"
           "\n bad input\n", inpmtx) ;
   if ( inpmtx != NULL ) {
      fprintf(stderr, "\n storage mode = %d, must be 1\n",
              inpmtx->storageMode) ;
   }
   exit(-1) ;
}
if ( (nent = inpmtx->nent) == 0 ) {
   inpmtx->storageMode = 2 ;
   return ;
}
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
if ( ivec1 == NULL || ivec2 == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_sortAndCompress(%p)"
           "\n nent = %d, ivec1 = %p, ivec2 = %p",
           inpmtx, nent, ivec1, ivec2) ;
   exit(-1) ;
}
if ( inpmtx->inputMode == 2 ) {
   dvec = DInpMtx_dvec(inpmtx) ;
   if ( dvec  == NULL ) {
      fprintf(stderr, "\n fatal error in DInpMtx_sortAndCompress(%p)"
              "\n nent = %d, dvec = %p\n", inpmtx, nent, dvec) ;
      exit(-1) ;
   }
} else {
   dvec = NULL ;
}
/*
   ----------------
   sort the triples
   ----------------
*/
/*
if ( inpmtx->inputMode == 2 ) {
   IV2DVqsortUp(nent, ivec1, ivec2, dvec) ;
} else {
   IV2qsortUp(nent, ivec1, ivec2) ;
}
ii   = 0 ;
prev = ivec1[0] ;
for ( jj = 1 ; jj < nent ; jj++ ) {
   if ( ivec1[jj] != prev ) {
      length = jj - ii ;
      if ( length > 1 ) {
         if ( inpmtx->inputMode == 2 ) {
            IVDVqsortUp(length, &ivec2[ii], &dvec[ii]) ;
         } else {
            IVqsortUp(length, &ivec2[ii]) ;
         }
      }
      ii = jj ;
      prev = ivec1[jj] ;
   }
}
length = jj - ii ;
if ( length > 1 ) {
   if ( inpmtx->inputMode == 2 ) {
      IVDVqsortUp(length, &ivec2[ii], &dvec[ii]) ;
   } else {
      IVqsortUp(length, &ivec2[ii]) ;
   }
}
*/
/*
   --------------------
   compress the triples
   --------------------
*/
/*
for ( ii = 0, jj = 1 ; jj < nent ; jj++ ) {
   if ( ivec1[ii] == ivec1[jj] && ivec2[ii] == ivec2[jj] ) {
      if ( inpmtx->inputMode == 2 ) {
         dvec[ii] += dvec[jj] ;
      }
   } else if ( ii != jj ) {
      ii++ ;
      ivec1[ii] = ivec1[jj] ;
      ivec2[ii] = ivec2[jj] ;
      if ( inpmtx->inputMode == 2 ) {
         dvec[ii]  = dvec[jj]  ;
      }
   }
}
inpmtx->nent = ii + 1 ;
*/
if ( dvec != NULL ) {
   inpmtx->nent = IV2DVsortUpAndCompress(nent, ivec1, ivec2, dvec) ;
} else {
   inpmtx->nent = IV2sortUpAndCompress(nent, ivec1, ivec2) ;
}
inpmtx->storageMode = 2 ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   convert from sorted and compressed triples to vector

   created -- 96jul05, cca
   ----------------------------------------------------
*/
void
DInpMtx_convertToVectors (
   DInpMtx   *inpmtx 
) {
int      *ivec1, *ivec2, *offsets, *sizes, *vecids ;
int      first, id, ient, jj, nent, nvector, value ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_convertToVectors(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->storageMode == 3 ) {
   return ;
}
if ( (nent = inpmtx->nent) == 0 ) {
   inpmtx->storageMode = 3 ;
   return ;
}
if ( inpmtx->storageMode == 1 ) {
   DInpMtx_sortAndCompress(inpmtx) ;
}
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
if ( ivec1 == NULL || ivec2 == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_convertToVectors(%p)"
           "\n nent = %d, ivec1 = %p, ivec2 = %p\n",
           inpmtx, nent, ivec1, ivec2) ;
   exit(-1) ;
}
/*
   -----------------------------------
   find the number of distinct vectors
   -----------------------------------
*/
value = -1 ;
nvector = 0 ;
for ( ient = 0 ; ient < nent ; ient++ ) {
   if ( ivec1[ient] >= 0 && value != ivec1[ient] ) {
      value = ivec1[ient] ;
      nvector++ ;
#if MYDEBUG > 0
      fprintf(stdout, "\n ient %d, value %d, nvector %d", 
              ient, value, nvector) ;
      fflush(stdout) ;
#endif
   }
}
#if MYDEBUG > 0
fprintf(stdout, "\n %d vectors", nvector) ;
fflush(stdout) ;
#endif
/*
   -----------------------------------------------------------------
   adjust the sizes of the sizes[] and offsets[] arrays if necessary
   -----------------------------------------------------------------
*/
DInpMtx_setNvector(inpmtx, nvector) ;
if ( nvector <= 0 ) {
/*
   -----------------------------
   matrix has no entries, return
   -----------------------------
*/
   inpmtx->storageMode = 3 ;
   DInpMtx_setNent(inpmtx, 0) ;
   return ;
}
vecids  = DInpMtx_vecids(inpmtx)  ;
sizes   = DInpMtx_sizes(inpmtx)   ;
offsets = DInpMtx_offsets(inpmtx) ;
/*
   ------------------------------------------------------------
   set the vector sizes and offsets
   note: we skip all entries whose first coordinate is negative
   ------------------------------------------------------------
*/
for ( first = 0 ; first < nent ; first++ ) {
   if ( ivec1[first] >= 0 ) {
      break ;
   }
}
id = 0 ;
if ( first < nent ) {
   value = ivec1[first] ;
   for ( jj = first + 1 ; jj < nent ; jj++ ) {
      if ( ivec1[jj] != value ) {
         vecids[id]  = value      ;
         sizes[id]   = jj - first ;
         offsets[id] = first      ;
#if MYDEBUG > 0
         fprintf(stdout, 
                 "\n vecids[%d] = %d, sizes[%d] = %d, offsets[%d] = %d",
                 id, vecids[id], id, sizes[id], id, offsets[id]) ;
         fflush(stdout) ;
#endif
         first       = jj         ;
         value       = ivec1[jj]  ;
         id++ ;
      }
   }
   vecids[id]  = value      ;
   sizes[id]   = jj - first ;
   offsets[id] = first      ;
#if MYDEBUG > 0
   fprintf(stdout, 
           "\n vecids[%d] = %d, sizes[%d] = %d, offsets[%d] = %d",
           id, vecids[id], id, sizes[id], id, offsets[id]) ;
   fflush(stdout) ;
#endif
}
inpmtx->storageMode = 3 ;
#if MYDEBUG > 0
fprintf(stdout, "\n vecidsIV") ;
IV_writeForHumanEye(&inpmtx->vecidsIV, stdout) ;
fprintf(stdout, "\n sizesIV") ;
IV_writeForHumanEye(&inpmtx->sizesIV, stdout) ;
fprintf(stdout, "\n offsetsIV") ;
IV_writeForHumanEye(&inpmtx->offsetsIV, stdout) ;
fflush(stdout) ;
#endif

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------
   drop off-diagonal entries

   created -- 97jan11, cca
   -------------------------
*/
void
DInpMtx_dropOffdiagonalEntries (
   DInpMtx   *inpmtx
) {
double   *dvec ;
int      count, ii, nent ;
int      *ivec1, *ivec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DInpMtx_dropOffdiagonalEntries(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, 
           "\n fatal error in DInpMtx_dropOffdiagonalEntries(%p)"
           "\n bad coordType = %d, must be 1, 2, or 3\n", 
           inpmtx, inpmtx->coordType) ;
   exit(-1) ;
}
nent  = inpmtx->nent ;
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
dvec  = DInpMtx_dvec(inpmtx) ;
count = 0 ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] == ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] == ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec2[ii] == 0 ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
}
inpmtx->nent = count ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   drop entries in the lower triangle

   created -- 97jan11, cca
   ----------------------------------
*/
void
DInpMtx_dropLowerTriangle (
   DInpMtx   *inpmtx
) {
double   *dvec ;
int      count, ii, nent ;
int      *ivec1, *ivec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_dropLowerTriangle(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, "\n fatal error in DInpMtx_dropLowerTriangle(%p)"
           "\n bad coordType = %d, must be 1, 2, or 3\n", 
           inpmtx, inpmtx->coordType) ;
   exit(-1) ;
}
nent  = inpmtx->nent ;
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
dvec  = DInpMtx_dvec(inpmtx) ;
count = 0 ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] <= ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] >= ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec2[ii] >= 0 ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
}
inpmtx->nent = count ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   drop entries in the upper triangle

   created -- 97jan11, cca
   ----------------------------------
*/
void
DInpMtx_dropUpperTriangle (
   DInpMtx   *inpmtx
) {
double   *dvec ;
int      count, ii, nent ;
int      *ivec1, *ivec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_dropUpperTriangle(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, "\n fatal error in DInpMtx_dropUpperTriangle(%p)"
           "\n bad coordType = %d, must be 1, 2, or 3\n", 
           inpmtx, inpmtx->coordType) ;
   exit(-1) ;
}
nent  = inpmtx->nent ;
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
dvec  = DInpMtx_dvec(inpmtx) ;
count = 0 ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] >= ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec1[ii] <= ivec2[ii] ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec2[ii] <= 0 ) {
         ivec1[count] = ivec1[ii] ;
         ivec2[count] = ivec2[ii] ;
         if ( dvec != NULL ) {
            dvec[count]  = dvec[ii]  ;
         }
         count++ ;
      }
   }
   break ;
}
inpmtx->nent = count ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   map entries into the lower triangle

   created -- 97jan11, cca
   -----------------------------------
*/
void
DInpMtx_mapToLowerTriangle (
   DInpMtx   *inpmtx
) {
int      col, ii, nent, row ;
int      *ivec1, *ivec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_mapToLowerTriangle(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, "\n fatal error in DInpMtx_mapToLowerTriangle(%p)"
           "\n bad coordType = %d, must be 1, 2, or 3\n", 
           inpmtx, inpmtx->coordType) ;
   exit(-1) ;
}
nent  = inpmtx->nent ;
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( (row = ivec1[ii]) < (col = ivec2[ii]) ) {
         ivec1[ii] = col ;
         ivec2[ii] = row ;
      }
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( (row = ivec2[ii]) < (col = ivec1[ii]) ) {
         ivec1[ii] = row ;
         ivec2[ii] = col ;
      }
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec2[ii] > 0 ) {
         ivec2[ii] = -ivec2[ii] ;
      }
   }
   break ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   map entries into the upper triangle

   created -- 97jan11, cca
   -----------------------------------
*/
void
DInpMtx_mapToUpperTriangle (
   DInpMtx   *inpmtx
) {
int      col, ii, nent, row ;
int      *ivec1, *ivec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_mapToUpperTriangle(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, "\n fatal error in DInpMtx_mapToUpperTriangle(%p)"
           "\n bad coordType = %d, must be 1, 2, or 3\n", 
           inpmtx, inpmtx->coordType) ;
   exit(-1) ;
}
nent  = inpmtx->nent ;
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( (row = ivec1[ii]) > (col = ivec2[ii]) ) {
         ivec1[ii] = col ;
         ivec2[ii] = row ;
      }
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( (row = ivec2[ii]) > (col = ivec1[ii]) ) {
         ivec1[ii] = row ;
         ivec2[ii] = col ;
      }
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < nent ; ii++ ) {
      if ( ivec2[ii] < 0 ) {
         ivec2[ii] = -ivec2[ii] ;
      }
   }
   break ;
}
inpmtx->storageMode = 1 ;

return ; }

/*--------------------------------------------------------------------*/
