/*  profile  */
 
#include "../DInpMtx.h"
 
/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------------------------
   to fill xDV and yDV with a log10 profile of the magnitudes of
   the entries in the DInpMtx object. tausmall and tau big provide
   cutoffs within which to examine the entries. pnsmall and pnbig 
   are address to hold the number of entries smaller than tausmall,

   and larger than taubig, respectively.
 
   created -- 97feb14, cca
   ------------------------------------------------------------------
*/
void
DInpMtx_log10profile (
   DInpMtx    *inpmtx,
   int        npts,
   DV         *xDV,
   DV         *yDV,
   double     tausmall,
   double     taubig,
   int        *pnzero,
   int        *pnsmall,
   int        *pnbig
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || inpmtx->inputMode != 2 
   || npts <= 0 || xDV == NULL || yDV == NULL 
   || tausmall < 0.0 || taubig < 0.0 || tausmall > taubig
   || pnzero == NULL || pnsmall == NULL || pnbig == NULL ) {
   fprintf(stderr, 
   "\n fatal error in DInpMtx_log10profile(%p,%d,%p,%p,%f,%f,%p,%p,%p)"
      "\n bad input\n",
       inpmtx, npts, xDV, yDV, tausmall, taubig, 
       pnzero, pnsmall, pnbig) ;
   exit(-1) ;
}
DV_log10profile(&inpmtx->dvecDV, npts, xDV, yDV, 
                tausmall, taubig, pnzero, pnsmall, pnbig) ;

return ; }

/*--------------------------------------------------------------------*/
