/*  permute.c  */

#include "../DInpMtx.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   permute the entries

   created -- 96jul05, cca
   -----------------------
*/
void
DInpMtx_permute (
   DInpMtx   *inpmtx,
   int       rowOldToNew[],
   int       colOldToNew[]
) {
int      col, ii, nent, row ;
int      *ivec1, *ivec2 ;
/*
   --------------
   check the data
   --------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_permute(%p,%p,%p)"
           "\n bad input\n", inpmtx, rowOldToNew, colOldToNew);
   exit(-1) ;
}
if ( inpmtx->coordType <= 0 || inpmtx->coordType >= 4 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_permute(%p,%p,%p)"
           "\n coordType = %d, must be 1, 2 or 3\n", 
           inpmtx, rowOldToNew, colOldToNew, inpmtx->coordType);
   exit(-1) ;
}
/*
   ----------------------
   check for quick return
   ----------------------
*/
if ( rowOldToNew == NULL && colOldToNew == NULL ) {
   return ; 
}
if ( (nent = inpmtx->nent) == 0 ) {
   return ;
}
ivec1 = DInpMtx_ivec1(inpmtx) ;
ivec2 = DInpMtx_ivec2(inpmtx) ;
if ( ivec1 == NULL || ivec2 == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_permute(%p,%p,%p)"
           "\n nent = %d, ivec1 = %p, ivec2 = %p",
           inpmtx, rowOldToNew, colOldToNew, nent, ivec1, ivec2) ;
   exit(-1) ;
}
if ( inpmtx->coordType == 3 ) {
/*
   ------------------------------------------
   convert chevron coordType to row coordType
   ------------------------------------------
*/
   DInpMtx_changeCoordType(inpmtx, 1) ;
}
/*
   --------------------------------------
   convert coordinates to new permutation
   --------------------------------------
*/
if ( inpmtx->coordType == 1 ) {
   for ( ii = 0 ; ii < nent ; ii++ ) {
      row = ivec1[ii] ;
      col = ivec2[ii] ;
      if ( 0 <= row && rowOldToNew != NULL ) {
         row = rowOldToNew[row] ;
      }
      if ( 0 <= col && colOldToNew != NULL ) {
         col = colOldToNew[col] ;
      }
      ivec1[ii] = row ;
      ivec2[ii] = col ;
   }
} else if ( inpmtx->coordType == 2 ) {
   for ( ii = 0 ; ii < nent ; ii++ ) {
      col = ivec1[ii] ;
      row = ivec2[ii] ;
      if ( 0 <= row && rowOldToNew != NULL ) {
         row = rowOldToNew[row] ;
      }
      if ( 0 <= col && colOldToNew != NULL ) {
         col = colOldToNew[col] ;
      }
      ivec1[ii] = col ;
      ivec2[ii] = row ;
   }
} 
/*
   -----------------------------------
   set the storage mode to raw triples
   -----------------------------------
*/
inpmtx->storageMode = 1 ;

return ; }
   
/*--------------------------------------------------------------------*/
