/*  instanceRead.c  */
 
#include "../DInpMtx.h"
 
/*--------------------------------------------------------------------*/
/*
   -----------------------
   returns coordinate type

   created -- 97feb06 jcp
   -----------------------
*/
int   
DInpMtx_coordType (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_coordType(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->coordType) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------
   returns storage mode

   created -- 97feb06 jcp
    ----------------------
*/
int   
DInpMtx_storageMode (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_storageMode(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->storageMode) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------
   returns input mode

   created -- 97feb06 jcp
   ----------------------
*/
int   
DInpMtx_inputMode (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_inputMode(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->inputMode) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   returns inpmtx->mxnent

   created -- 97feb06 jcp
   -----------------------
*/
int   
DInpMtx_maxnent (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_maxnent(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->maxnent) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   returns inpmtx->nent

   created -- 97feb06 jcp
   -----------------------
*/
int   
DInpMtx_nent (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_nent(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->nent) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------
   returns inpmtx->mxnvector

   created -- 97feb06 jcp
   -------------------------
*/
int   
DInpMtx_maxnvector (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_maxnvector(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->maxnvector) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   returns inpmtx->nvector

   created -- 97feb06 jcp
   -----------------------
*/
int   
DInpMtx_nvector (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_nvector(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->nvector) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------
   returns inpmtx->resizeMultiple

   created -- 97feb06 jcp
   ------------------------------
*/
double   
DInpMtx_resizeMultiple (
   DInpMtx  *inpmtx
) {
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_resizeMultiple(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(inpmtx->resizeMultiple) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   returns pointer to ivec1[] vector

   created -- 97feb06 jcp
   ---------------------------------
*/
int *   
DInpMtx_ivec1 (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_ivec1(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(IV_entries(&inpmtx->ivec1IV)) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   returns pointer to ivec2[] vector

   created -- 97feb06 jcp
   ---------------------------------
*/
int *   
DInpMtx_ivec2 (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_ivec2(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(IV_entries(&inpmtx->ivec2IV)) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------
   returns pointer to dvec[] vector

   created -- 97feb06 jcp
   --------------------------------
*/
double *   
DInpMtx_dvec (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_dvec(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(DV_entries(&inpmtx->dvecDV)) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   returns pointer to sizes[] vector

   created -- 97feb06 jcp
   ---------------------------------
*/
int *   
DInpMtx_sizes (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_sizes(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(IV_entries(&inpmtx->sizesIV)) ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   returns pointer to vecids[] vector

   created -- 97jul11 cca
   ----------------------------------
*/
int *   
DInpMtx_vecids (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_vecids(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(IV_entries(&inpmtx->vecidsIV)) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------
   returns pointer to offsets[] vector

   created -- 97feb06 jcp
   -----------------------------------
*/
int *   
DInpMtx_offsets (
   DInpMtx  *inpmtx
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_offsets(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
return(IV_entries(&inpmtx->offsetsIV)) ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------
   retrieve requested vector
   set *pnent to # of entries
       *pindices to address of first index
       *pentries to address of first entry

   created -- 97jan09, jcp
   ---------------------------------------
*/
void
DInpMtx_vector (
   DInpMtx   *inpmtx,
   int       id,
   int       *pnent,
   int       **pindices,
   double    **pentries
) {
int   loc, off ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || inpmtx->storageMode != 3 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_vector(%p,%d,%p,%p,%p)"
           "\n bad input\n", inpmtx, id, pnent, pindices, pentries) ;
   if ( inpmtx != NULL ) {
      fprintf(stderr, "\n storage mode = %d, must be 3\n",
              inpmtx->storageMode) ;
   }
   exit(-1) ;
}
if (   pnent == NULL || pindices == NULL 
    || (inpmtx->inputMode == 2 && pentries == NULL) ) {
   fprintf(stderr, "\n fatal error in DInpMtx_vector(%p,%d,%p,%p,%p)"
           "\n NULL input, pnent = %p, pindices = %p, pentries = %p",
	   inpmtx, id, pnent, pindices, pentries,
	   pnent, pindices, pentries) ;
   exit(-1) ;
}
/*
   -------------------------------
   find the location of the vector
   -------------------------------
*/
loc = IV_findValueAscending(&inpmtx->vecidsIV, id) ;
if ( loc == -1 ) {
/*
   ------------------------------------------------------------
   vector is not present, set size to zero and pointers to NULL
   ------------------------------------------------------------
*/
   *pnent    =   0  ;
   *pindices = NULL ;
   if ( inpmtx->inputMode == 2 ) {
      *pentries = NULL ;
   }
} else {
/*
  --------------------------------------------------------------
  fill *pnent with the number of entries in vector id.
  fill *pindices with the pointer to the first index in vector id.
  fill *pentries with the pointer to the first entry in vector id.
  --------------------------------------------------------------
*/
   *pnent    = inpmtx->sizesIV.vec[loc]   ;
   off       = inpmtx->offsetsIV.vec[loc] ;
   *pindices = inpmtx->ivec2IV.vec + off  ;
   if ( inpmtx->inputMode == 2 ) {
      *pentries = inpmtx->dvecDV.vec + off ;
   }
}
return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------------------
   sets the maximum numnber of entries.  this methods resizes the
   ivec1[], ivece2[] and dvec[] vectors if newmaxnent != maxnent

   created -- 97feb06 jcp
   --------------------------------------------------------------
*/
void   
DInpMtx_setMaxnent (
   DInpMtx  *inpmtx, 
   int      newmaxnent
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || newmaxnent < 0 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setMaxnent(%p, %d)"
           "\n bad input\n", inpmtx, newmaxnent) ;
   exit(-1) ;
}
if ( newmaxnent != inpmtx->maxnent ) {
  IV_setMaxsize(&(inpmtx->ivec1IV), newmaxnent) ;
  IV_setMaxsize(&(inpmtx->ivec2IV), newmaxnent) ;
  if ( inpmtx->inputMode == 2 ) {
    DV_setMaxsize(&(inpmtx->dvecDV), newmaxnent) ;
  }
}
inpmtx->maxnent = newmaxnent ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   set the present number of entries

   created -- 97Jan21, jcp
   --------------------------------
*/
void
DInpMtx_setNent (
   DInpMtx   *inpmtx,
   int       newnent
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || newnent < 0 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setNent(%p,%d)"
           "\n bad input\n", inpmtx, newnent) ;
   exit(-1) ;
}
if ( inpmtx->maxnent < newnent ) {
/*
   -------------------------------------------------------
   newnent requested is more than maxnent, set new maxnent 
   -------------------------------------------------------
*/
   DInpMtx_setMaxnent(inpmtx, newnent) ;
}
inpmtx->nent = newnent ;
IV_setSize(&inpmtx->ivec1IV, newnent) ;
IV_setSize(&inpmtx->ivec2IV, newnent) ;
if ( inpmtx->inputMode == 2 ) {
   DV_setSize(&inpmtx->dvecDV, newnent) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   sets the maximum number of vectors. 
   if newmaxnent != maxnent then this methods resizes 
   the vecids[], sizes[] and offsets[] vectors 

   created  -- 97feb06, jcp
   modified -- 97jul11, cca
   --------------------------------------------------
*/
void   
DInpMtx_setMaxnvector (
   DInpMtx  *inpmtx, 
   int      newmaxnvector
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || newmaxnvector < 0 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_Maxnvector(%p, %d)"
           "\n bad input\n", inpmtx, newmaxnvector) ;
   exit(-1) ;
}
if ( newmaxnvector != inpmtx->maxnvector ) {
  IV_setMaxsize(&(inpmtx->vecidsIV),  newmaxnvector) ;
  IV_setMaxsize(&(inpmtx->sizesIV),   newmaxnvector) ;
  IV_setMaxsize(&(inpmtx->offsetsIV), newmaxnvector) ;
}
inpmtx->maxnvector = newmaxnvector ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------------
   set the present number of vectors

   created -- 97feb08, cca
   ---------------------------------
*/
void   
DInpMtx_setNvector (
   DInpMtx   *inpmtx, 
   int       newnvector
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || newnvector < 0 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setNvector(%p, %d)"
           "\n bad input\n", inpmtx, newnvector) ;
   exit(-1) ;
}
if ( newnvector > inpmtx->maxnvector ) {
  DInpMtx_setMaxnvector(inpmtx, newnvector) ;
}
inpmtx->nvector = newnvector ;
IV_setSize(&inpmtx->vecidsIV,  newnvector) ;
IV_setSize(&inpmtx->sizesIV,   newnvector) ;
IV_setSize(&inpmtx->offsetsIV, newnvector) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------
   sets inpmtx->resizeMultiple

   created -- 97feb06 jcp
    ---------------------------
*/
void   
DInpMtx_setResizeMultiple (
   DInpMtx   *inpmtx, 
   double    resizeMultiple
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || resizeMultiple < 0 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setResizeMultiple(%p,%f)"
           "\n bad input\n", inpmtx, resizeMultiple) ;
   exit(-1) ;
}
inpmtx->resizeMultiple = resizeMultiple ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   sets coordType of DInpMtx structure to
   allow user to define custom coordinate type.
   Note, new type must be > 3.

   created -- 97feb06 jcp
    --------------------------------------------
*/
void   
DInpMtx_setCoordType (
   DInpMtx  *inpmtx, 
   int      type
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || type <= 3 ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setCoordType(%p,%d)"
           "\n bad input\n", inpmtx, type) ;
   if ( type <= 3 ) 
     fprintf(stderr, "\n fatal error in DInpMtx_setCoordType"
           "\n reserved coordinate type %d \n", type) ;
      
   exit(-1) ;
}
inpmtx->coordType = type ;

return ; }    

/*--------------------------------------------------------------------*/
