/*  fullAdj.c  */

#include "../DInpMtx.h"

#define MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- to return the full, symmetric adjacency IVL object
              for the graph of A + A^T

   created -- 97oct22, cca
   -------------------------------------------------------------
*/
IVL *
DInpMtx_fullAdjacency (
   DInpMtx   *inpmtx
) {
double    *ient, *jent ;
int       count, ierr, ii, isize, ivtx, jvtx, jsize, kvtx, nvtx ;
int       *head, *iind, *jind, *link, *list, *mark, *offsets ;
IVL       *adjIVL ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_fullAdjacency(%p)"
           "\n NULL input\n", inpmtx) ;
   exit(-1) ;
}
/*
    ----------------------
    check for empty matrix
    ----------------------
*/
if ( inpmtx->nent == 0 ) {
   return(NULL) ;
}
/*
   ---------------------------------------------------------
   change the coordinates to rows and storage mode to vector
   ---------------------------------------------------------
*/
DInpMtx_changeCoordType(inpmtx, 1) ;
DInpMtx_changeStorageMode(inpmtx, 3) ;
nvtx = 1 + IV_max(&inpmtx->ivec1IV) ;
if ( nvtx < (count = 1 + IV_max(&inpmtx->ivec2IV)) ) {
   nvtx = count ;
}
/*
   -------------------------
   initialize the IVL object
   -------------------------
*/
adjIVL = IVL_new() ;
IVL_init1(adjIVL, IVL_CHUNKED, nvtx) ;
list    = IVinit(nvtx, -1) ;
mark    = IVinit(nvtx, -1) ;
offsets = IVinit(nvtx,  0) ;
head    = IVinit(nvtx, -1) ;
link    = IVinit(nvtx, -1) ;
/*
   -----------------
   link the vertices
   -----------------
*/
for ( jvtx = 0 ; jvtx < nvtx ; jvtx++ ) {
   DInpMtx_vector(inpmtx, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
      kvtx          = jind[0] ;
      link[jvtx]    = head[kvtx] ;
      head[kvtx]    = jvtx ;
      offsets[jvtx] = 0 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n    linking %d to %d", jvtx, kvtx) ;
      fflush(stdout) ;
#endif
   }
}   
for ( jvtx = 0 ; jvtx < nvtx ; jvtx++ ) {
#if MYDEBUG > 0
   fprintf(stdout, "\n vertex %d :", jvtx) ;
   fflush(stdout) ;
#endif
   list[0] = jvtx ;
#if MYDEBUG > 0
   fprintf(stdout, "\n    0. adding %d", jvtx) ;
   fflush(stdout) ;
#endif
   mark[jvtx] = jvtx ;
   count = 1 ;
/*
   ----------------------------
   get the indices for row jvtx
   ----------------------------
*/
   DInpMtx_vector(inpmtx, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
/*
      ----------------------------
      add row indices for row jvtx
      ----------------------------
*/
#if MYDEBUG > 0
         fprintf(stdout, "\n    DInpMtx row %d :", jvtx) ;
         IVfp80(stdout, jsize, jind, 20, &ierr) ;
         fflush(stdout) ;
#endif
      for ( ii = 0 ; ii < jsize ; ii++ ) {
         kvtx = jind[ii] ;
         if ( mark[kvtx] != jvtx ) {
            mark[kvtx] = jvtx ;
            list[count++] = kvtx ;
#if MYDEBUG > 0
            fprintf(stdout, "\n    1. adding %d", kvtx) ;
            fflush(stdout) ;
#endif
         }
      }
   }
/*
      -------------------------------------
      check previous rows that contain jvtx
      -------------------------------------
*/
   while ( (ivtx = head[jvtx]) != -1 ) {
#if MYDEBUG > 0
      fprintf(stdout, "\n    2. link from %d", ivtx) ;
      fflush(stdout) ;
#endif
      head[jvtx] = link[ivtx] ;
      if ( mark[ivtx] != jvtx ) {
         mark[ivtx] = jvtx ;
         list[count++] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", ADDING %d", ivtx) ;
         fflush(stdout) ;
#endif
      }
      DInpMtx_vector(inpmtx, ivtx, &isize, &iind, &ient) ;
      if ( ++offsets[ivtx] < isize ) {
         kvtx = iind[offsets[ivtx]] ;
         link[ivtx] = head[kvtx] ;
         head[kvtx] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", linking %d to %d", ivtx, kvtx) ;
         fflush(stdout) ;
#endif
      }
   }
/*
   ------------------------------------------------
   list is complete, sort and insert into adjacency
   ------------------------------------------------
*/
   IVqsortUp(count, list) ;
   IVL_setList(adjIVL, jvtx, count, list) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
IVfree(list) ;
IVfree(mark) ;
IVfree(offsets) ;
IVfree(head) ;
IVfree(link) ;

return(adjIVL) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------
   purpose -- to return the full, symmetric adjacency IVL object
              for the graph of (A + B) + (A + B)^T

   created -- 97nov05, cca
   -------------------------------------------------------------
*/
IVL *
DInpMtx_fullAdjacency2 (
   DInpMtx   *inpmtxA,
   DInpMtx   *inpmtxB
) {
double    *ient, *jent ;
int       count, ierr, ii, isize, ivtx, jvtx, jsize, kvtx, nvtx ;
int       *headA, *headB, *iind, *jind, *linkA, *linkB,
          *list, *mark, *offsetsA, *offsetsB ;
IVL       *adjIVL ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtxA == NULL && inpmtxB == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_fullAdjacency2(%p,%p)"
           "\n both input matrices are NULL\n", inpmtxA, inpmtxB) ;
   exit(-1) ;
}
/*
   ------------------------------
   cases where one matrix is NULL
   ------------------------------
*/
if ( inpmtxA == NULL ) {
   adjIVL = DInpMtx_fullAdjacency(inpmtxB) ;
   return(adjIVL) ;
} else if ( inpmtxB == NULL ) {
   adjIVL = DInpMtx_fullAdjacency(inpmtxA) ;
   return(adjIVL) ;
}
/*
   ---------------------------------------------------------
   change the coordinates to rows and storage mode to vector
   ---------------------------------------------------------
*/
DInpMtx_changeCoordType(inpmtxA, 1) ;
DInpMtx_changeStorageMode(inpmtxA, 3) ;
nvtx = 1 + IV_max(&inpmtxA->ivec1IV) ;
if ( nvtx < (count = 1 + IV_max(&inpmtxA->ivec2IV)) ) {
   nvtx = count ;
}
DInpMtx_changeCoordType(inpmtxB, 1) ;
DInpMtx_changeStorageMode(inpmtxB, 3) ;
if ( nvtx < (count = 1 + IV_max(&inpmtxB->ivec1IV)) ) {
   nvtx = count ;
}
if ( nvtx < (count = 1 + IV_max(&inpmtxB->ivec2IV)) ) {
   nvtx = count ;
}
/*
   -------------------------
   initialize the IVL object
   -------------------------
*/
adjIVL = IVL_new() ;
IVL_init1(adjIVL, IVL_CHUNKED, nvtx) ;
/*
   ------------------------------
   initialize the working storage
   ------------------------------
*/
list     = IVinit(nvtx, -1) ;
mark     = IVinit(nvtx, -1) ;
offsetsA = IVinit(nvtx,  0) ;
headA    = IVinit(nvtx, -1) ;
linkA    = IVinit(nvtx, -1) ;
offsetsB = IVinit(nvtx,  0) ;
headB    = IVinit(nvtx, -1) ;
linkB    = IVinit(nvtx, -1) ;
/*
   -----------------
   link the vertices
   -----------------
*/
for ( jvtx = 0 ; jvtx < nvtx ; jvtx++ ) {
   DInpMtx_vector(inpmtxA, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
      kvtx           = jind[0] ;
      linkA[jvtx]    = headA[kvtx] ;
      headA[kvtx]    = jvtx ;
      offsetsA[jvtx] = 0 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n A : linking %d to %d", jvtx, kvtx) ;
      fflush(stdout) ;
#endif
   }
   DInpMtx_vector(inpmtxB, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
      kvtx           = jind[0] ;
      linkB[jvtx]    = headB[kvtx] ;
      headB[kvtx]    = jvtx ;
      offsetsB[jvtx] = 0 ;
#if MYDEBUG > 0
      fprintf(stdout, "\n B : linking %d to %d", jvtx, kvtx) ;
      fflush(stdout) ;
#endif
   }
}   
for ( jvtx = 0 ; jvtx < nvtx ; jvtx++ ) {
#if MYDEBUG > 0
   fprintf(stdout, "\n vertex %d :", jvtx) ;
   fflush(stdout) ;
#endif
   list[0] = jvtx ;
#if MYDEBUG > 0
   fprintf(stdout, "\n    0. adding %d", jvtx) ;
   fflush(stdout) ;
#endif
   mark[jvtx] = jvtx ;
   count = 1 ;
/*
   ----------------------------
   get the indices for row jvtx
   ----------------------------
*/
   DInpMtx_vector(inpmtxA, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
/*
      ----------------------------
      add row indices for row jvtx
      ----------------------------
*/
#if MYDEBUG > 0
         fprintf(stdout, "\n A's row %d :", jvtx) ;
         IVfp80(stdout, jsize, jind, 20, &ierr) ;
         fflush(stdout) ;
#endif
      for ( ii = 0 ; ii < jsize ; ii++ ) {
         kvtx = jind[ii] ;
         if ( mark[kvtx] != jvtx ) {
            mark[kvtx] = jvtx ;
            list[count++] = kvtx ;
#if MYDEBUG > 0
            fprintf(stdout, "\n    A1. adding %d", kvtx) ;
            fflush(stdout) ;
#endif
         }
      }
   }
/*
      -------------------------------------
      check previous rows that contain jvtx
      -------------------------------------
*/
   while ( (ivtx = headA[jvtx]) != -1 ) {
#if MYDEBUG > 0
      fprintf(stdout, "\n    A2. link from %d", ivtx) ;
      fflush(stdout) ;
#endif
      headA[jvtx] = linkA[ivtx] ;
      if ( mark[ivtx] != jvtx ) {
         mark[ivtx] = jvtx ;
         list[count++] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", ADDING %d", ivtx) ;
         fflush(stdout) ;
#endif
      }
      DInpMtx_vector(inpmtxA, ivtx, &isize, &iind, &ient) ;
      if ( ++offsetsA[ivtx] < isize ) {
         kvtx = iind[offsetsA[ivtx]] ;
         linkA[ivtx] = headA[kvtx] ;
         headA[kvtx] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", linking %d to %d", ivtx, kvtx) ;
         fflush(stdout) ;
#endif
      }
   }
   DInpMtx_vector(inpmtxB, jvtx, &jsize, &jind, &jent) ;
   if ( jsize > 0 ) {
/*
      ----------------------------
      add row indices for row jvtx
      ----------------------------
*/
#if MYDEBUG > 0
         fprintf(stdout, "\n B's row %d :", jvtx) ;
         IVfp80(stdout, jsize, jind, 20, &ierr) ;
         fflush(stdout) ;
#endif
      for ( ii = 0 ; ii < jsize ; ii++ ) {
         kvtx = jind[ii] ;
         if ( mark[kvtx] != jvtx ) {
            mark[kvtx] = jvtx ;
            list[count++] = kvtx ;
#if MYDEBUG > 0
            fprintf(stdout, "\n    B1. adding %d", kvtx) ;
            fflush(stdout) ;
#endif
         }
      }
   }
/*
      -------------------------------------
      check previous rows that contain jvtx
      -------------------------------------
*/
   while ( (ivtx = headB[jvtx]) != -1 ) {
#if MYDEBUG > 0
      fprintf(stdout, "\n    B2. link from %d", ivtx) ;
      fflush(stdout) ;
#endif
      headB[jvtx] = linkB[ivtx] ;
      if ( mark[ivtx] != jvtx ) {
         mark[ivtx] = jvtx ;
         list[count++] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", ADDING %d", ivtx) ;
         fflush(stdout) ;
#endif
      }
      DInpMtx_vector(inpmtxB, ivtx, &isize, &iind, &ient) ;
      if ( ++offsetsB[ivtx] < isize ) {
         kvtx = iind[offsetsB[ivtx]] ;
         linkB[ivtx] = headB[kvtx] ;
         headB[kvtx] = ivtx ;
#if MYDEBUG > 0
         fprintf(stdout, ", linking %d to %d", ivtx, kvtx) ;
         fflush(stdout) ;
#endif
      }
   }
/*
   ------------------------------------------------
   list is complete, sort and insert into adjacency
   ------------------------------------------------
*/
   IVqsortUp(count, list) ;
   IVL_setList(adjIVL, jvtx, count, list) ;
}
/*
   ------------------------
   free the working storage
   ------------------------
*/
IVfree(list) ;
IVfree(mark) ;
IVfree(offsetsA) ;
IVfree(headA) ;
IVfree(linkA) ;
IVfree(offsetsB) ;
IVfree(headB) ;
IVfree(linkB) ;

return(adjIVL) ; }

/*--------------------------------------------------------------------*/
