/*  extract.c  */

#include "../DInpMtx.h"

/*--------------------------------------------------------------------*/
/*
   -------------------------------------------------------------------
   purpose -- extract vectors from the matrix.
   note: if the coordinate type is rows, we extract full rows.
         if the coordinate type is columns, we extract full columns.
         if the coordinate type is chevrons, we extract full chevrons.

   created -- 97feb28, cca
   -------------------------------------------------------------------
*/
DInpMtx *
DInpMtx_extractVectors (
   DInpMtx   *inpmtx,
   IV        *idsIV
) {
DInpMtx   *newmtx ;
double    *entries ;
int       id, ii, nent, size ;
int       *ids, *indices ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || idsIV == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_extractVectors(%p,%p)"
           "\n bad input\n", inpmtx, idsIV) ;
   exit(-1) ;
}
if ( inpmtx->coordType < 1 || 3 < inpmtx->coordType ) {
   fprintf(stderr, "\n fatal error in DInpMtx_extractVectors(%p,%p)"
           "\n bad coordType %d\n", inpmtx, idsIV, inpmtx->coordType) ;
   exit(-1) ;
}
/*
   ------------------------------
   convert to vector storage mode
   ------------------------------
*/
DInpMtx_changeStorageMode(inpmtx, 3) ;
/*
   -------------------------------
   initialize a new DInpMtx object
   -------------------------------
*/
newmtx = DInpMtx_new() ;
DInpMtx_init(newmtx, inpmtx->coordType, inpmtx->inputMode, 0, 0) ;
/*
   -------------------------------------------
   extract data and insert into the new object
   -------------------------------------------
*/
IV_sizeAndEntries(idsIV, &size, &ids) ;
switch ( inpmtx->coordType ) {
case 1 :
   for ( ii = 0 ; ii < size ; ii++ ) {
      id = ids[ii] ;
      DInpMtx_vector(inpmtx, id, &nent, &indices, &entries) ;
      DInpMtx_inputRow(newmtx, id, nent, indices, entries) ;
   }
   break ;
case 2 :
   for ( ii = 0 ; ii < size ; ii++ ) {
      id = ids[ii] ;
      DInpMtx_vector(inpmtx, id, &nent, &indices, &entries) ;
      DInpMtx_inputColumn(newmtx, id, nent, indices, entries) ;
   }
   break ;
case 3 :
   for ( ii = 0 ; ii < size ; ii++ ) {
      id = ids[ii] ;
      DInpMtx_vector(inpmtx, id, &nent, &indices, &entries) ;
      DInpMtx_inputChevron(newmtx, id, nent, indices, entries) ;
   }
   break ;
}
return(newmtx) ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------------
   purpose -- extract a submatrix.

   entry a(i,j) is extracted 
   if rowmark[i] == rowtag and colmark[i] == coltag

   created -- 97mar01, cca
   ------------------------------------------------
*/
DInpMtx *
DInpMtx_extractSubmatrix (
   DInpMtx   *inpmtx,
   IV        *rowmarkIV,
   int       rowtag,
   IV        *colmarkIV,
   int       coltag
) {
DInpMtx   *newmtx ;
double    *entries ;
int       ii, irow, jcol, nent, ncol, nrow ;
int       *colmark, *indices, *rowmark ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL || rowmarkIV == NULL || colmarkIV == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DInpMtx_extractSubmatrix(%p,%p,%d,%p,%d)"
           "\n bad input\n", 
           inpmtx, rowmarkIV, rowtag, colmarkIV, coltag) ;
   exit(-1) ;
}
IV_sizeAndEntries(rowmarkIV, &nrow, &rowmark) ;
IV_sizeAndEntries(colmarkIV, &ncol, &colmark) ;
if ( rowmark == NULL || colmark == NULL ) {
   fprintf(stderr, 
           "\n fatal error in DInpMtx_extractSubmatrix(%p,%p,%d,%p,%d)"
           "\n rowmark = %p, colmark = %p\n", inpmtx, rowmarkIV, 
           rowtag, colmarkIV, coltag, rowmark, colmark) ;
   exit(-1) ;
}
/*
   ----------------------------------------------------
   convert coordType to rows and storageMode to vectors
   ----------------------------------------------------
*/
DInpMtx_changeCoordType(inpmtx, 1) ;
DInpMtx_changeStorageMode(inpmtx, 3) ;
if ( nrow != DInpMtx_nvector(inpmtx) ) {
   fprintf(stderr, 
           "\n fatal error in DInpMtx_extractSubmatrix(%p,%p,%d,%p,%d)"
           "\n nrow = %d from rowmarkIV, nrow = %d from inpmtx",
           inpmtx, rowmarkIV, rowtag, colmarkIV, coltag, 
           nrow, DInpMtx_nvector(inpmtx)) ;
   exit(-1) ;
}
/*
   -------------------------------
   initialize a new DInpMtx object
   -------------------------------
*/
newmtx = DInpMtx_new() ;
DInpMtx_init(newmtx, inpmtx->coordType, inpmtx->inputMode, 0, 0) ;
/*
   ------------------
   loop over the rows
   ------------------
*/
for ( irow = 0 ; irow < nrow ; irow++ ) {
   if ( rowmark[irow] == rowtag ) {
      DInpMtx_vector(inpmtx, irow, &nent, &indices, &entries) ;
      for ( ii = 0 ; ii < nent ; ii++ ) {
         jcol = indices[ii] ;
         if ( colmark[jcol] == coltag ) {
            if ( entries != NULL ) {
               DInpMtx_inputEntry(newmtx, irow, jcol, entries[ii]) ;
            } else {
               DInpMtx_inputEntry(newmtx, irow, jcol, 0.0) ;
            }
         }
      }
   }
}
return(newmtx) ; }

/*--------------------------------------------------------------------*/
