/*  basics.c  */

#include "../DInpMtx.h"

#define   MYDEBUG 0

/*--------------------------------------------------------------------*/
/*
   -----------------------
   simplest constructor

   created -- 96jul05, cca
   -----------------------
*/
DInpMtx *
DInpMtx_new ( 
   void 
) {
DInpMtx   *inpmtx ;

ALLOCATE(inpmtx, struct _DInpMtx, 1) ;
DInpMtx_setDefaultFields(inpmtx) ;

return(inpmtx) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 96jul05, cca
   -----------------------
*/
void
DInpMtx_setDefaultFields (
   DInpMtx   *inpmtx
) {
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_setDefaultFields(%p)"
           "\n bad input", inpmtx) ;
   exit(-1) ;
}
inpmtx->coordType      =   0  ;
inpmtx->storageMode    =   1  ;
inpmtx->inputMode      =   2  ;
inpmtx->maxnent        =   0  ;
inpmtx->nent           =   0  ;
inpmtx->resizeMultiple = 1.25 ;
inpmtx->maxnvector     =   0  ;
inpmtx->nvector        =   0  ;
IV_setDefaultFields(&inpmtx->ivec1IV)   ;
IV_setDefaultFields(&inpmtx->ivec2IV)   ;
DV_setDefaultFields(&inpmtx->dvecDV)    ;
IV_setDefaultFields(&inpmtx->vecidsIV)  ;
IV_setDefaultFields(&inpmtx->sizesIV)   ;
IV_setDefaultFields(&inpmtx->offsetsIV) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   clear the data fields, releasing allocated storage

   created -- 96jul05, cca
   --------------------------------------------------
*/
void
DInpMtx_clearData ( 
   DInpMtx   *inpmtx 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_clearData(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
/*
   -----------------------------------------------------
   free any storage held in the IV and DV vector objects
   -----------------------------------------------------
*/
IV_clearData(&inpmtx->ivec1IV)   ;
IV_clearData(&inpmtx->ivec2IV)   ;
DV_clearData(&inpmtx->dvecDV)    ;
IV_clearData(&inpmtx->vecidsIV)  ;
IV_clearData(&inpmtx->sizesIV)   ;
IV_clearData(&inpmtx->offsetsIV) ;
/*
   ----------------------
   set the default fields
   ----------------------
*/
DInpMtx_setDefaultFields(inpmtx) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ------------------------------------------
   destructor, free's the object and its data

   created -- 96jul05, cca
   ------------------------------------------
*/
DInpMtx *
DInpMtx_free ( 
   DInpMtx   *inpmtx 
) {
if ( inpmtx == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_free(%p)"
           "\n bad input\n", inpmtx) ;
   exit(-1) ;
}
DInpMtx_clearData(inpmtx) ;
FREE(inpmtx) ;

return(NULL) ; }

/*--------------------------------------------------------------------*/
