/*  adjForATA.c  */

#include "../DInpMtx.h"

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   return an IVL object that contains 
   the adjacency structure of A^TA.

   created -- 97nov17, cca
   ----------------------------------
*/
IVL *
DInpMtx_adjForATA (
   DInpMtx   *inpmtxA
) {
DInpMtx   *inpmtxATA ;
double    *ent ;
int       firstcol, firstrow, irow, jvtx, lastcol, lastrow,
          loc, ncol, nent, nrow, size ;
int       *ind, *ivec1, *ivec2 ;
IVL       *adjIVL ;
/*
   ---------------
   check the input
   ---------------
*/
if ( inpmtxA == NULL ) {
   fprintf(stderr, "\n fatal error in DInpMtx_adjForATA(%p)"
           "\n NULL input\n", inpmtxA) ;
   exit(-1) ;
}
/*
   ----------------------------------------------------------
   change the coordinate type and storage mode to row vectors
   ----------------------------------------------------------
*/
DInpMtx_changeCoordType(inpmtxA, 1) ;
DInpMtx_changeStorageMode(inpmtxA, 3) ;
nent     = DInpMtx_nent(inpmtxA) ;
ivec1    = DInpMtx_ivec1(inpmtxA) ;
ivec2    = DInpMtx_ivec2(inpmtxA) ;
firstrow = IVmin(nent, ivec1, &loc) ;
lastrow  = IVmax(nent, ivec1, &loc) ;
firstcol = IVmin(nent, ivec2, &loc) ;
lastcol  = IVmax(nent, ivec2, &loc) ;
if ( firstrow < 0 || firstcol < 0 ) {
   fprintf(stderr, "\n fatal error"
           "\n firstrow = %d, firstcol = %d"
           "\n lastrow  = %d, lastcol  = %d",
           firstrow, firstcol, lastrow, lastcol) ;
   exit(-1) ;
}
nrow = 1 + lastrow ;
ncol = 1 + lastcol ;
/*
   -----------------------------------------------------------
   create the new DInpMtx object to hold the structure of A^TA
   -----------------------------------------------------------
*/
inpmtxATA = DInpMtx_new() ;
DInpMtx_init(inpmtxATA, 1, 1, 0, 0) ;
for ( irow = 0 ; irow < nrow ; irow++ ) {
   DInpMtx_vector(inpmtxA, irow, &size, &ind, &ent) ;
   DInpMtx_inputMatrix(inpmtxATA, size, size, 1, 1, ind, ind, NULL) ;
}
for ( jvtx = 0 ; jvtx < ncol ; jvtx++ ) {
   DInpMtx_inputEntry(inpmtxATA, jvtx, jvtx, 0.0) ;
}
DInpMtx_changeStorageMode(inpmtxATA, 3) ;
/*
   -------------------
   fill the IVL object
   -------------------
*/
adjIVL = IVL_new() ;
IVL_init1(adjIVL, IVL_CHUNKED, ncol) ;
for ( jvtx = 0 ; jvtx < ncol ; jvtx++ ) {
   DInpMtx_vector(inpmtxATA, jvtx, &size, &ind, &ent) ;
   IVL_setList(adjIVL, jvtx, size, ind) ;
}
return(adjIVL) ; }

/*--------------------------------------------------------------------*/
