/*  testIO.c  */

#include "../DInpMtx.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ---------------------------------------------------
   test DInpMtx_readFromFile and DInpMtx_writeToFile,
   useful for translating between formatted *.dinpmtxf
   and binary *.dinpmtxb files.

   created -- 95dec17, cca
   ---------------------------------------------------
*/
{
int       msglvl, rc ;
DInpMtx   inpmtx ;
FILE      *msgFile ;

if ( argc != 5 ) {
   fprintf(stdout, 
      "\n\n usage : testIO msglvl msgFile inFile outFile"
      "\n    msglvl   -- message level"
      "\n    msgFile  -- message file"
      "\n    inFile   -- input file, must be *.dinpmtxf or *.dinpmtxb"
      "\n    outFile  -- output file, must be *.dinpmtxf or *.dinpmtxb"
      "\n") ;
   return ;
}
msglvl = atoi(argv[1]) ;
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n fatal error in %s"
           "\n unable to open file %s\n",
           argv[0], argv[2]) ;
   return ;
}
fprintf(msgFile, 
        "\n testIO "
        "\n msglvl   -- %d" 
        "\n msgFile  -- %s" 
        "\n inFile   -- %s" 
        "\n outFile  -- %s" 
        "\n",
        msglvl, argv[2], argv[3], argv[4]) ;
fflush(msgFile) ;
/*
   ----------------------
   set the default fields
   ----------------------
*/
DInpMtx_setDefaultFields(&inpmtx) ;
if ( msglvl > 0 ) {
   fprintf(msgFile, "\n\n after setting default fields") ;
   DInpMtx_writeForHumanEye(&inpmtx, msgFile) ;
   fflush(msgFile) ;
}
/*
   --------------------------
   read in the DInpMtx object
   --------------------------
*/
if ( strcmp(argv[3], "none") == 0 ) {
   fprintf(msgFile, "\n no file to read from") ;
   exit(0) ;
}
rc = DInpMtx_readFromFile(&inpmtx, argv[3]) ;
fprintf(msgFile, "\n return value %d from DInpMtx_readFromFile(%p,%s)",
        rc, &inpmtx, argv[3]) ;
if ( rc != 1 ) {
   exit(-1) ;
}
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n after reading DInpMtx object from file %s",
           argv[3]) ;
   DInpMtx_writeForHumanEye(&inpmtx, msgFile) ;
   fflush(msgFile) ;
}
/*
   ----------------------------------
   change the storage mode to vectors
   ----------------------------------
*/
DInpMtx_changeCoordType(&inpmtx, 1) ;
DInpMtx_changeStorageMode(&inpmtx, 1) ;
/*
DInpMtx_changeCoordType(&inpmtx, 3) ;
DInpMtx_changeStorageMode(&inpmtx, 3) ;
*/
if ( msglvl > 2 ) {
   fprintf(msgFile, "\n\n after changing storage mode") ;
   DInpMtx_writeForHumanEye(&inpmtx, msgFile) ;
   fflush(msgFile) ;
}
/*
   ---------------------------
   write out the DInpMtx object
   ---------------------------
*/
if ( strcmp(argv[4], "none") != 0 ) {
   rc = DInpMtx_writeToFile(&inpmtx, argv[4]) ;
   fprintf(msgFile, 
           "\n return value %d from DInpMtx_writeToFile(%p,%s)",
           rc, &inpmtx, argv[4]) ;
}

fprintf(msgFile, "\n") ;
fclose(msgFile) ;

return ; }

/*--------------------------------------------------------------------*/
